/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest;

import com.codahale.metrics.annotation.Timed;
import io.github.jhipster.web.util.ResponseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.domain.enumeration.FileType;
import org.powertac.visualizer.repository.UserRepository;
import org.powertac.visualizer.security.SecurityUtils;
import org.powertac.visualizer.service.FileService;
import org.powertac.visualizer.service.GameService;
import org.powertac.visualizer.service_ptac.SyncFilesService;
import org.powertac.visualizer.web.rest.util.HeaderUtil;
import org.powertac.visualizer.web.rest.util.PaginationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class FileResource {
    private final Logger log = LoggerFactory.getLogger(FileResource.class);
    private static final String ENTITY_NAME = "file";
    private final FileService fileService;
    private final GameService gameService;
    private final UserRepository userRepository;
    @Autowired
    private SyncFilesService syncFilesService;

    public FileResource(FileService fileService, GameService gameService, UserRepository userRepository) {
        this.fileService = fileService;
        this.gameService = gameService;
        this.userRepository = userRepository;
    }

    @PostMapping(value={"/files"})
    @Timed
    public ResponseEntity<org.powertac.visualizer.domain.File> createFile(@Valid @RequestBody org.powertac.visualizer.domain.File file) throws URISyntaxException {
        this.log.debug("REST request to save File : {}", (Object)file);
        if (file.getId() != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(HeaderUtil.createFailureAlert((String)ENTITY_NAME, (String)"idexists", (String)"A new file cannot already have an ID"))).body(null);
        }
        String login = SecurityUtils.getCurrentUserLogin();
        User user = this.userRepository.findOneByLogin(login).orElse(null);
        file.setOwner(user);
        org.powertac.visualizer.domain.File result = this.fileService.save(file);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/files/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/files"})
    @Timed
    public ResponseEntity<org.powertac.visualizer.domain.File> updateFile(@Valid @RequestBody org.powertac.visualizer.domain.File file) throws URISyntaxException {
        this.log.debug("REST request to update File : {}", (Object)file);
        if (file.getId() == null) {
            return this.createFile(file);
        }
        org.powertac.visualizer.domain.File result = this.fileService.save(file);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)ENTITY_NAME, (String)file.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/files"})
    @Timed
    public ResponseEntity<List<org.powertac.visualizer.domain.File>> getAllFiles(Pageable pageable) throws URISyntaxException {
        this.log.debug("REST request to get a page of Files");
        Page page = this.fileService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((Page)page, (String)"/api/files");
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/files/{id}"})
    @Timed
    public ResponseEntity<org.powertac.visualizer.domain.File> getFile(@PathVariable Long id) {
        this.log.debug("REST request to get File : {}", (Object)id);
        org.powertac.visualizer.domain.File file = this.fileService.getOne(id);
        return ResponseUtil.wrapOrNotFound(Optional.ofNullable(file));
    }

    @DeleteMapping(value={"/files/{id}"})
    @Timed
    public ResponseEntity<Void> deleteFile(@PathVariable Long id) {
        this.log.debug("REST request to delete File : {}", (Object)id);
        org.powertac.visualizer.domain.File file = this.fileService.getOne(id);
        if (file != null) {
            this.fileService.delete(file);
            file.getType().getFile(file.getOwner(), file.getName()).delete();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityDeletionAlert((String)ENTITY_NAME, (String)id.toString()))).build();
    }

    @GetMapping(value={"/myfiles/{type}/"})
    @Timed
    public ResponseEntity<List<org.powertac.visualizer.domain.File>> getMyFiles(@Valid @NotNull @PathVariable String type) throws URISyntaxException {
        this.syncFilesService.syncFileSystem();
        FileType fileType = FileType.valueOf((String)type.toUpperCase());
        this.log.debug("REST request to get owned and shared files, type = " + type);
        String login = SecurityUtils.getCurrentUserLogin();
        List list = this.fileService.findByOwnerIsCurrentUserOrShared(login, fileType);
        return new ResponseEntity((Object)list, HttpStatus.OK);
    }

    @GetMapping(value={"/myfiles/{type}/{id}"})
    @Timed
    public void getMyFile(@Valid @NotNull @PathVariable String type, @Valid @NotNull @PathVariable Long id, HttpServletResponse response) throws IOException {
        this.log.debug("REST request to download a file");
        FileType fileType = FileType.valueOf((String)type.toUpperCase());
        if (fileType == null) {
            throw new IllegalArgumentException("Unknown type " + type);
        }
        org.powertac.visualizer.domain.File file = this.fileService.getOne(id);
        File raw = fileType.getFile(file.getOwner(), file.getName());
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(raw));
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
            response.setHeader("Content-Type", fileType.getContentType());
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    /*
     * Exception decompiling
     */
    @PostMapping(value={"/myfiles/{type}/"})
    @Timed
    public ResponseEntity<org.powertac.visualizer.domain.File> postFile(@Valid @NotNull @PathVariable String type, @RequestParam(value="shared") Boolean shared, @RequestParam(value="overwrite") Boolean overwrite, @Valid @NotNull @RequestParam(value="file") MultipartFile part) throws IOException, URISyntaxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

