/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.config;

import io.github.jhipster.config.JHipsterProperties;
import java.time.Duration;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.jsr107.Eh107Configuration;
import org.powertac.visualizer.config.DatabaseConfiguration;
import org.powertac.visualizer.config.MetricsConfiguration;
import org.powertac.visualizer.config.WebConfigurer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.JCacheManagerCustomizer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
@AutoConfigureAfter(value={MetricsConfiguration.class})
@AutoConfigureBefore(value={WebConfigurer.class, DatabaseConfiguration.class})
public class CacheConfiguration {
    private final javax.cache.configuration.Configuration<Object, Object> jcacheConfiguration;

    public CacheConfiguration(JHipsterProperties jHipsterProperties) {
        JHipsterProperties.Cache.Ehcache ehcache = jHipsterProperties.getCache().getEhcache();
        this.jcacheConfiguration = Eh107Configuration.fromEhcacheCacheConfiguration((org.ehcache.config.CacheConfiguration)CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)ehcache.getMaxEntries())).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(ehcache.getTimeToLiveSeconds()))).build());
    }

    @Bean
    public JCacheManagerCustomizer cacheManagerCustomizer() {
        return cm -> {
            cm.createCache("usersByLogin", this.jcacheConfiguration);
            cm.createCache("usersByEmail", this.jcacheConfiguration);
        };
    }
}

