/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.repository_ptac;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.powertac.visualizer.domain.Broker;
import org.powertac.visualizer.repository_ptac.RecycleRepository;
import org.springframework.stereotype.Service;

@Service
public class BrokerRepository
implements RecycleRepository<Broker> {
    private Map<String, Broker> brokerMapName = new LinkedHashMap();
    private Map<Long, Broker> brokerMapId = new LinkedHashMap();

    public synchronized Broker save(Broker broker) {
        this.brokerMapName.put(broker.getName(), broker);
        this.brokerMapId.put(broker.getId(), broker);
        return broker;
    }

    public synchronized Broker findByName(String brokerName) {
        return (Broker)this.brokerMapName.get(brokerName);
    }

    public synchronized Broker findById(long brokerId) {
        return (Broker)this.brokerMapId.get(brokerId);
    }

    public synchronized List<Broker> findAll() {
        return new ArrayList<Broker>(this.brokerMapName.values());
    }

    public synchronized void recycle() {
        this.brokerMapName.clear();
        this.brokerMapId.clear();
    }
}

