/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service_ptac;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.powertac.visualizer.config.ApplicationProperties;
import org.powertac.visualizer.domain.Broker;
import org.powertac.visualizer.domain.Customer;
import org.powertac.visualizer.domain.Tariff;
import org.powertac.visualizer.repository_ptac.RecycleRepository;
import org.powertac.visualizer.service_ptac.VisualizerService;
import org.powertac.visualizer.web.websocket.Pusher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class VisualizerService {
    private Logger log = LoggerFactory.getLogger(VisualizerService.class);
    @Autowired
    private ApplicationContext context;
    @Autowired
    private Pusher pusher;
    private Collection<RecycleRepository> repositories;
    private VisualizerState state;
    @Autowired
    private ApplicationProperties applicationProperties;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        String mode = this.applicationProperties.getMode().trim();
        if (mode == null || mode.isEmpty()) {
            this.log.debug("No mode provided, falling back to 'research'");
            mode = "research";
            this.applicationProperties.setMode(mode);
        }
        if (mode.equals("tournament")) {
            if (this.applicationProperties.getConnect().getServerUrl().isEmpty()) {
                throw new RuntimeException("In tournament mode, a 'serverUrl' is required!");
            }
        } else if (!mode.equals("research")) {
            throw new RuntimeException("Unsupported mode '" + mode + "'");
        }
        this.state = VisualizerState.IDLE;
        this.registerAllRecyclables();
    }

    public String getMode() {
        return this.applicationProperties.getMode();
    }

    public int getTimeslotPause() {
        return this.applicationProperties.getTimeslotPause();
    }

    public String getMachineName() {
        return this.applicationProperties.getConnect().getMachineName();
    }

    public String getServerUrl() {
        return this.applicationProperties.getConnect().getServerUrl();
    }

    public String getTournamentUrl() {
        return this.applicationProperties.getConnect().getTournamentUrl();
    }

    public String getTournamentPath() {
        return this.applicationProperties.getConnect().getTournamentPath();
    }

    public void newRun() {
        this.init();
    }

    public void init() {
        this.recycleAll();
    }

    public void registerAllRecyclables() {
        this.repositories = this.context.getBeansOfType(RecycleRepository.class).values();
    }

    public void recycleAll() {
        for (RecycleRepository repository : this.repositories) {
            repository.recycle();
        }
        Broker.recycle();
        Customer.recycle();
        Tariff.recycle();
    }

    public VisualizerState getState() {
        return this.state;
    }

    public void setState(VisualizerState state) {
        this.state = state;
        this.pusher.sendGameStatusMessage(state);
    }
}

