/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.powertac.visualizer.domain.Broker;
import org.powertac.visualizer.domain.RetailKPIHolder;
import org.powertac.visualizer.domain.WholesaleKPIHolder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TickValueBroker {
    private long id;
    private double cash;
    private RetailKPIHolder retail;
    private WholesaleKPIHolder wholesale;

    protected TickValueBroker() {
    }

    public TickValueBroker(Broker broker, RetailKPIHolder retail, WholesaleKPIHolder wholesale) {
        this.id = broker.getId();
        this.cash = broker.getCash();
        this.retail = retail.isEmpty() ? null : retail;
        this.wholesale = wholesale.isEmpty() ? null : wholesale;
    }

    public long getId() {
        return this.id;
    }

    public RetailKPIHolder getRetail() {
        return this.retail;
    }

    public WholesaleKPIHolder getWholesale() {
        return this.wholesale;
    }

    public double getCash() {
        return this.cash;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.retail == null && this.wholesale == null && this.cash == 0.0;
    }
}

