/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest;

import com.codahale.metrics.annotation.Timed;
import io.github.jhipster.web.util.ResponseUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileExistsException;
import org.powertac.visualizer.domain.Game;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.domain.enumeration.FileType;
import org.powertac.visualizer.repository.UserRepository;
import org.powertac.visualizer.security.SecurityUtils;
import org.powertac.visualizer.service.GameService;
import org.powertac.visualizer.service_ptac.EmbeddedService;
import org.powertac.visualizer.service_ptac.VisualizerService;
import org.powertac.visualizer.web.rest.util.HeaderUtil;
import org.powertac.visualizer.web.rest.util.PaginationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class GameResource {
    private final Logger log = LoggerFactory.getLogger(GameResource.class);
    private static final String ENTITY_NAME = "game";
    private final GameService gameService;
    private UserRepository userRepository;
    @Autowired
    private VisualizerService visualizerService;
    @Autowired
    private EmbeddedService embeddedService;

    public GameResource(GameService gameService, UserRepository userRepository) {
        this.gameService = gameService;
        this.userRepository = userRepository;
    }

    @PostMapping(value={"/games"})
    @Timed
    public ResponseEntity<Game> createGame(@Valid @RequestBody Game game) throws URISyntaxException {
        this.log.debug("REST request to save Game : {}", (Object)game);
        if (game.getId() != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(HeaderUtil.createFailureAlert((String)ENTITY_NAME, (String)"idexists", (String)"A new game cannot already have an ID"))).body(null);
        }
        String login = SecurityUtils.getCurrentUserLogin();
        User user = this.userRepository.findOneByLogin(login).orElse(null);
        game.setOwner(user);
        if (game.getDate() == null) {
            game.setDate(ZonedDateTime.now());
        }
        Game result = this.gameService.save(game);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/games/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/games"})
    @Timed
    public ResponseEntity<Game> updateGame(@Valid @RequestBody Game game) throws URISyntaxException {
        this.log.debug("REST request to update Game : {}", (Object)game);
        if (game.getId() == null) {
            return this.createGame(game);
        }
        if (game.getDate() == null) {
            game.setDate(ZonedDateTime.now());
        }
        Game result = this.gameService.save(game);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)ENTITY_NAME, (String)game.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/games"})
    @Timed
    public ResponseEntity<List<Game>> getAllGames(Pageable pageable) throws URISyntaxException {
        this.log.debug("REST request to get a page of Games");
        Page page = this.gameService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((Page)page, (String)"/api/games");
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/games/{id}"})
    @Timed
    public ResponseEntity<Game> getGame(@PathVariable Long id) {
        this.log.debug("REST request to get Game : {}", (Object)id);
        Optional game = this.gameService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)game);
    }

    @DeleteMapping(value={"/games/{id}"})
    @Timed
    public ResponseEntity<Void> deleteGame(@PathVariable Long id) {
        this.log.debug("REST request to delete Game : {}", (Object)id);
        Optional game = this.gameService.findOne(id);
        game.ifPresent(arg_0 -> ((GameService)this.gameService).delete(arg_0));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityDeletionAlert((String)ENTITY_NAME, (String)id.toString()))).build();
    }

    @GetMapping(value={"/mygames"})
    @Timed
    public ResponseEntity<List<Game>> getMyGames() throws URISyntaxException {
        this.log.debug("REST request to get owned and shared games");
        String login = SecurityUtils.getCurrentUserLogin();
        List list = this.gameService.findByOwnerIsCurrentUserOrShared(login);
        return new ResponseEntity((Object)list, HttpStatus.OK);
    }

    @PostMapping(value={"/bootgame"})
    @Timed
    public ResponseEntity<Game> bootGame(@Valid @RequestBody Game game, @RequestParam(value="overwrite") @Valid @NotNull Boolean overwrite) throws URISyntaxException, FileExistsException {
        String error;
        this.log.debug("REST request to start a boot game");
        if (this.visualizerService.getMode().equals("tournament")) {
            throw new IllegalStateException("Not available in tournament mode");
        }
        if (this.visualizerService.getState().equals((Object)VisualizerService.VisualizerState.RUNNING)) {
            throw new IllegalStateException("Visualizer already has a game running");
        }
        String login = SecurityUtils.getCurrentUserLogin();
        User user = this.userRepository.findOneByLogin(login).orElse(null);
        List check = this.gameService.findByNameAndType(login, game.getName(), game.getType());
        if (check.size() > 0) {
            if (overwrite.booleanValue()) {
                for (Game g : check) {
                    this.gameService.delete(g);
                }
            } else {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(HeaderUtil.createFailureAlert((String)ENTITY_NAME, (String)"nameexists", (String)"A boot game already exists for this name"))).body(null);
            }
        }
        game.setOwner(user);
        if (game.getDate() == null) {
            game.setDate(ZonedDateTime.now());
        }
        if ((error = this.embeddedService.runBootGame(game, user)) != null) {
            this.embeddedService.closeGame();
            throw new RuntimeException(error);
        }
        game = this.gameService.save(game);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/games/" + game.getId())).headers(HeaderUtil.createAlert((String)(game.getType() + " game '" + game.getName() + "' started"), null))).body((Object)game);
    }

    @PostMapping(value={"/simgame"})
    @Timed
    public ResponseEntity<Game> simGame(@Valid @RequestBody Game game, @RequestParam(value="overwrite") @Valid @NotNull Boolean overwrite) throws URISyntaxException {
        String error;
        this.log.debug("REST request to start a sim game");
        if (this.visualizerService.getMode().equals("tournament")) {
            throw new IllegalStateException("Not available in tournament mode");
        }
        if (this.visualizerService.getState().equals((Object)VisualizerService.VisualizerState.RUNNING)) {
            throw new IllegalStateException("Visualizer already has a game running");
        }
        String login = SecurityUtils.getCurrentUserLogin();
        User user = this.userRepository.findOneByLogin(login).orElse(null);
        List check = this.gameService.findByNameAndType(login, game.getName(), game.getType());
        if (check.size() > 0) {
            if (overwrite.booleanValue()) {
                for (Game g : check) {
                    this.gameService.delete(g);
                }
            } else {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(HeaderUtil.createFailureAlert((String)ENTITY_NAME, (String)"nameexists", (String)"A sim game already exists for this name"))).body(null);
            }
        }
        game.setOwner(user);
        if (game.getDate() == null) {
            game.setDate(ZonedDateTime.now());
        }
        if ((error = this.embeddedService.runSimGame(game, user)) != null) {
            this.embeddedService.closeGame();
            throw new RuntimeException(error);
        }
        game = this.gameService.save(game);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/games/" + game.getId())).headers(HeaderUtil.createAlert((String)(game.getType() + " game '" + game.getName() + "' started"), null))).body((Object)game);
    }

    @PostMapping(value={"/replaygame_internal"})
    @Timed
    public ResponseEntity<Void> replayGameInternal(@Valid @RequestBody org.powertac.visualizer.domain.File file) throws URISyntaxException, IOException {
        this.log.debug("REST request to replay an internal game");
        if (!file.getType().equals((Object)FileType.STATE)) {
            throw new IllegalArgumentException("Expected a state file");
        }
        if (this.visualizerService.getMode().equals("tournament")) {
            throw new IllegalStateException("Not available in tournament mode");
        }
        if (this.visualizerService.getState().equals((Object)VisualizerService.VisualizerState.RUNNING)) {
            throw new IllegalStateException("Visualizer already has a game running");
        }
        FileInputStream source = new FileInputStream(new File(file.getPath()));
        String error = this.embeddedService.runReplayGame((InputStream)source);
        if (error != null) {
            throw new RuntimeException(error);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createAlert((String)("Replaying game from '" + file.getPath() + "'"), null))).body(null);
    }

    @PostMapping(value={"/replaygame_external"})
    @Timed
    public ResponseEntity<Void> replayGameExternal(@Valid @RequestBody String url) throws URISyntaxException, MalformedURLException, IOException {
        this.log.debug("REST request to replay an external game");
        if (this.visualizerService.getMode().equals("tournament")) {
            throw new IllegalStateException("Not available in tournament mode");
        }
        if (this.visualizerService.getState().equals((Object)VisualizerService.VisualizerState.RUNNING)) {
            throw new IllegalStateException("Visualizer already has a game running");
        }
        InputStream source = new URL(url).openStream();
        String error = this.embeddedService.runReplayGame(source);
        if (error != null) {
            throw new RuntimeException(error);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createAlert((String)("Replaying game from '" + url + "'"), null))).body(null);
    }

    @PostMapping(value={"/closegame"})
    @Timed
    public ResponseEntity<Void> closeGame() throws IllegalStateException {
        this.log.debug("REST request to start a game");
        if (this.visualizerService.getMode().equals("tournament")) {
            throw new IllegalStateException("Not available in tournament mode");
        }
        this.embeddedService.closeGame();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createAlert((String)"Game stopped", null))).body(null);
    }
}

