/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest;

import com.codahale.metrics.annotation.Timed;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.domain.View;
import org.powertac.visualizer.repository.UserRepository;
import org.powertac.visualizer.security.SecurityUtils;
import org.powertac.visualizer.service.ViewService;
import org.powertac.visualizer.web.rest.util.HeaderUtil;
import org.powertac.visualizer.web.rest.util.PaginationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ViewResource {
    private final Logger log = LoggerFactory.getLogger(ViewResource.class);
    private static final String ENTITY_NAME = "view";
    private final ViewService viewService;
    private final UserRepository userRepository;

    public ViewResource(ViewService viewService, UserRepository userRepository) {
        this.viewService = viewService;
        this.userRepository = userRepository;
    }

    @PostMapping(value={"/views"})
    @Timed
    public ResponseEntity<View> createView(@Valid @RequestBody View view) throws URISyntaxException {
        this.log.debug("REST request to save View : {}", (Object)view);
        if (view.getId() != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(HeaderUtil.createFailureAlert((String)ENTITY_NAME, (String)"idexists", (String)"A new view cannot already have an ID"))).body(null);
        }
        String login = SecurityUtils.getCurrentUserLogin();
        User user = this.userRepository.findOneByLogin(login).orElse(null);
        view.setOwner(user);
        View result = this.viewService.save(view);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/views/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/views"})
    @Timed
    public ResponseEntity<View> updateView(@Valid @RequestBody View view) throws URISyntaxException {
        this.log.debug("REST request to update View : {}", (Object)view);
        if (view.getId() == null) {
            return this.createView(view);
        }
        View result = this.viewService.save(view);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)ENTITY_NAME, (String)view.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/views"})
    @Timed
    public ResponseEntity<List<View>> getAllViews(Pageable pageable) throws URISyntaxException {
        this.log.debug("REST request to get a page of Views");
        Page page = this.viewService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((Page)page, (String)"/api/views");
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/views/{id}"})
    @Timed
    public ResponseEntity<View> getView(@PathVariable Long id) {
        this.log.debug("REST request to get View : {}", (Object)id);
        Optional view = this.viewService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)view);
    }

    @DeleteMapping(value={"/views/{id}"})
    @Timed
    public ResponseEntity<Void> deleteView(@PathVariable Long id) {
        this.log.debug("REST request to delete View : {}", (Object)id);
        Optional view = this.viewService.findOne(id);
        view.ifPresent(arg_0 -> ((ViewService)this.viewService).delete(arg_0));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityDeletionAlert((String)ENTITY_NAME, (String)id.toString()))).build();
    }

    @GetMapping(value={"/myviews"})
    @Timed
    public ResponseEntity<List<View>> getMyViews() throws URISyntaxException {
        this.log.debug("REST request to get owned and shared views");
        String login = SecurityUtils.getCurrentUserLogin();
        List list = this.viewService.findByOwnerIsCurrentUserOrShared(login);
        return new ResponseEntity((Object)list, HttpStatus.OK);
    }
}

