/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest.util;

import java.net.URISyntaxException;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PaginationUtil {
    private PaginationUtil() {
    }

    public static HttpHeaders generatePaginationHttpHeaders(Page page, String baseUrl) throws URISyntaxException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Total-Count", Long.toString(page.getTotalElements()));
        Object link = "";
        if (page.getNumber() + 1 < page.getTotalPages()) {
            link = "<" + PaginationUtil.generateUri((String)baseUrl, (int)(page.getNumber() + 1), (int)page.getSize()) + ">; rel=\"next\",";
        }
        if (page.getNumber() > 0) {
            link = (String)link + "<" + PaginationUtil.generateUri((String)baseUrl, (int)(page.getNumber() - 1), (int)page.getSize()) + ">; rel=\"prev\",";
        }
        int lastPage = 0;
        if (page.getTotalPages() > 0) {
            lastPage = page.getTotalPages() - 1;
        }
        link = (String)link + "<" + PaginationUtil.generateUri((String)baseUrl, (int)lastPage, (int)page.getSize()) + ">; rel=\"last\",";
        link = (String)link + "<" + PaginationUtil.generateUri((String)baseUrl, (int)0, (int)page.getSize()) + ">; rel=\"first\"";
        headers.add("Link", (String)link);
        return headers;
    }

    private static String generateUri(String baseUrl, int page, int size) throws URISyntaxException {
        return UriComponentsBuilder.fromUriString((String)baseUrl).queryParam("page", new Object[]{page}).queryParam("size", new Object[]{size}).toUriString();
    }
}

