/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.powertac.visualizer.domain.User;

@Entity
@Table(name="jhi_persistent_token")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PersistentToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_USER_AGENT_LEN = 255;
    @Id
    private String series;
    @JsonIgnore
    @NotNull
    @Column(name="token_value", nullable=false)
    private String tokenValue;
    @Column(name="token_date")
    private LocalDate tokenDate;
    @Size(min=0, max=39)
    @Column(name="ip_address", length=39)
    private @Size(min=0, max=39) String ipAddress;
    @Column(name="user_agent")
    private String userAgent;
    @JsonIgnore
    @ManyToOne
    private User user;

    public String getSeries() {
        return this.series;
    }

    public void setSeries(String series) {
        this.series = series;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public void setTokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
    }

    public LocalDate getTokenDate() {
        return this.tokenDate;
    }

    public void setTokenDate(LocalDate tokenDate) {
        this.tokenDate = tokenDate;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent.length() >= 255 ? userAgent.substring(0, 254) : userAgent;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentToken that = (PersistentToken)o;
        return this.series.equals(that.series);
    }

    public int hashCode() {
        return this.series.hashCode();
    }

    public String toString() {
        return "PersistentToken{series='" + this.series + "', tokenValue='" + this.tokenValue + "', tokenDate=" + this.tokenDate + ", ipAddress='" + this.ipAddress + "', userAgent='" + this.userAgent + "'}";
    }
}

