/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.powertac.visualizer.domain.Chart;
import org.powertac.visualizer.domain.User;

@Entity
@Table(name="view")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class View
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @Size(min=1, max=255)
    @Column(name="name", length=255, nullable=false)
    private @NotNull @Size(min=1, max=255) String name;
    @NotNull
    @Size(min=1, max=255)
    @Column(name="graphs", length=255, nullable=false)
    private @NotNull @Size(min=1, max=255) String graphs;
    @Transient
    private List<Long> graphIdList;
    @NotNull
    @Column(name="shared", nullable=false)
    private Boolean shared;
    @ManyToOne
    private User owner;
    @ManyToOne
    private Chart chart;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGraphs() {
        return this.graphs;
    }

    public List<Long> getGraphIdList() {
        if (this.graphIdList == null && this.graphs != null) {
            this.graphIdList = Arrays.asList(this.graphs.split("\\s*,\\s*")).stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
        }
        return this.graphIdList;
    }

    public void setGraphs(String graphs) {
        this.graphs = graphs;
        this.graphIdList = null;
    }

    public Boolean isShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User user) {
        this.owner = user;
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View view = (View)o;
        if (view.id == null || this.id == null) {
            return false;
        }
        return Objects.equals(this.id, view.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "View{id=" + this.id + ", name='" + this.name + "', graphs='" + this.graphs + "', shared='" + this.shared + "'}";
    }
}

