/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.repository_ptac;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.powertac.visualizer.domain.Customer;
import org.powertac.visualizer.repository_ptac.RecycleRepository;
import org.springframework.stereotype.Service;

@Service
public class CustomerRepository
implements RecycleRepository<Customer> {
    private Map<String, Customer> customerNameMap = new LinkedHashMap();
    private Map<Long, Customer> customerIdMap = new LinkedHashMap();

    public synchronized Customer save(Customer customer) {
        this.customerNameMap.put(customer.getName(), customer);
        this.customerIdMap.put(customer.getIdCustomerInfo(), customer);
        return customer;
    }

    public synchronized Customer findByName(String brokerName) {
        return (Customer)this.customerNameMap.get(brokerName);
    }

    public synchronized Customer findById(long idCustomerInfo) {
        return (Customer)this.customerIdMap.get(idCustomerInfo);
    }

    public synchronized List<Customer> findAll() {
        return new ArrayList<Customer>(this.customerNameMap.values());
    }

    public synchronized void recycle() {
        this.customerNameMap.clear();
        this.customerIdMap.clear();
    }
}

