/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service_ptac;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.msg.BrokerAccept;
import org.powertac.common.msg.BrokerAuthentication;
import org.powertac.common.msg.VisualizerStatusRequest;
import org.powertac.common.repo.DomainRepo;
import org.powertac.visualizer.service_ptac.MessageDispatcher;
import org.powertac.visualizer.service_ptac.MessageHandler;
import org.powertac.visualizer.service_ptac.TournamentService;
import org.powertac.visualizer.service_ptac.VisualizerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@EnableScheduling
@Service
@Configuration
public class TournamentService
implements MessageListener {
    private static Logger log = LoggerFactory.getLogger((String)TournamentService.class.getName());
    @Autowired
    private VisualizerService visualizerService;
    @Autowired
    private ApplicationContext context;
    @Resource(name="jmsFactory")
    private CachingConnectionFactory connectionFactory;
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    @Autowired
    private MessageDispatcher dispatcher;
    @Autowired
    private XMLMessageConverter converter;
    private MessageFeeder messageFeeder = null;
    private StateRunner stateRunner = null;
    private BlockingQueue<TournamentEvent> eventQueue = new LinkedBlockingQueue();
    private BlockingQueue<Object> messageQueue = new LinkedBlockingQueue();
    private LocalVisualizerProxy proxy;
    private boolean initialized = false;
    private long maxMsgInterval = 120000L;
    private long maxGameReadyInterval = 300000L;
    private long gameReadyAt = 0L;
    private long lastMsgTime = 0L;
    private String mode;
    private String tournamentUrl;
    private String visualizerLoginContext;
    private String machineName;
    private String serverUrl;
    private String serverQueue = "serverInput";
    private String queueName = "remote-visualizer";

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.mode = this.visualizerService.getMode();
        if (!this.mode.equals("tournament")) {
            return;
        }
        this.tournamentUrl = this.visualizerService.getTournamentUrl();
        this.visualizerLoginContext = this.visualizerService.getTournamentPath();
        this.machineName = this.visualizerService.getMachineName();
        this.serverUrl = this.visualizerService.getServerUrl();
        new Timer(true).schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 10000L);
    }

    public void init() {
        this.messageFeeder = new MessageFeeder(this);
        this.messageFeeder.setDaemon(true);
        this.messageFeeder.start();
        this.stateRunner = new StateRunner(this);
        this.stateRunner.setDaemon(true);
        this.stateRunner.start();
    }

    private void initOnce() {
        this.initialized = true;
        log.info("initOnce()");
        this.visualizerService.newRun();
        Collection handlers = this.context.getBeansOfType(MessageHandler.class).values();
        for (MessageHandler handler : handlers) {
            log.debug("initializing..." + handler.getClass().getName());
            handler.initialize();
        }
        Collection repos = this.context.getBeansOfType(DomainRepo.class).values();
        for (DomainRepo repo : repos) {
            log.debug("recycling..." + repos.getClass().getName());
            repo.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PreDestroy
    private void cleanUp() throws Exception {
        try {
            if (this.proxy != null) {
                this.proxy.shutdown();
            }
            this.messageQueue.clear();
            this.putMessage((Object)TournamentEvent.QUIT);
            if (this.messageFeeder != null) {
                this.messageFeeder.join();
            }
            this.eventQueue.clear();
            this.putEvent(TournamentEvent.QUIT);
            if (this.stateRunner != null) {
                this.stateRunner.join();
            }
            for (Thread t : Thread.getAllStackTraces().keySet()) {
                if (!t.getName().contains("Timer-") && !t.getName().contains("ActiveMQ")) continue;
                Thread thread = t;
                synchronized (thread) {
                    t.stop();
                }
            }
            return;
        }
        catch (Exception x) {
            log.warn("Error in TournamentService.cleanUp()", (Throwable)x);
            throw x;
        }
    }

    private void recycle() {
        this.initialized = false;
        if (this.proxy != null) {
            log.info("shut down proxy");
            this.proxy.shutdown();
        }
        this.proxy = null;
        this.connectionFactory.destroy();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String getTournamentState() {
        if (!this.visualizerService.getMode().equals("tournament")) {
            return "";
        }
        if (this.stateRunner != null && this.stateRunner.getTournamentState() != null) {
            return this.stateRunner.getTournamentState().toString();
        }
        return "Not ready";
    }

    private boolean isInactive() {
        long now = new Date().getTime();
        long silence = now - this.lastMsgTime;
        if (silence > this.maxMsgInterval) {
            log.info("Inactivity declared");
            return true;
        }
        return false;
    }

    private void putEvent(TournamentEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private TournamentEvent getEvent() {
        try {
            return (TournamentEvent)this.eventQueue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return TournamentEvent.TICK;
        }
    }

    private void tournamentLogin() {
        if (this.tournamentUrl.isEmpty()) {
            this.putEvent(TournamentEvent.NOTM);
            return;
        }
        String urlString = this.tournamentUrl + this.visualizerLoginContext + "?machineName=" + this.machineName + "&machineLoad=" + this.getLoad();
        log.info("tourney url=" + urlString);
        try {
            URL url = new URL(urlString);
            URLConnection conn = url.openConnection();
            InputStream input = conn.getInputStream();
            log.info("Parsing message..");
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(input);
            doc.getDocumentElement().normalize();
            Node retryNode = doc.getElementsByTagName("retry").item(0);
            Node loginNode = doc.getElementsByTagName("login").item(0);
            if (retryNode != null) {
                String checkRetry = retryNode.getFirstChild().getNodeValue();
                log.info("Retry in " + checkRetry + " seconds");
                try {
                    Thread.sleep(Integer.parseInt(checkRetry) * 1000);
                }
                catch (InterruptedException interruptedException) {}
            } else if (loginNode != null) {
                log.info("Login response received! ");
                this.queueName = doc.getElementsByTagName("queueName").item(0).getFirstChild().getNodeValue();
                this.serverQueue = doc.getElementsByTagName("serverQueue").item(0).getFirstChild().getNodeValue();
                log.info(String.format("Login message received: queueName=%s, serverQueue=%s", this.queueName, this.serverQueue));
                this.putEvent(TournamentEvent.ACCEPT);
            } else {
                log.info("Invalid response from TS");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private double getLoad() {
        OperatingSystemMXBean mxBean = ManagementFactory.getOperatingSystemMXBean();
        return mxBean.getSystemLoadAverage();
    }

    private void gameLogin() {
        log.info("Ping sim server");
        if (null == this.proxy) {
            this.proxy = new LocalVisualizerProxy(this);
            this.proxy.init(this);
        }
        this.proxy.sendMessage((Object)new VisualizerStatusRequest());
    }

    public void onMessage(Message message) {
        this.lastMsgTime = new Date().getTime();
        if (message instanceof TextMessage) {
            try {
                this.onMessage(((TextMessage)message).getText());
            }
            catch (JMSException e) {
                log.info("ERROR: viz failed to extract text from TextMessage: " + e.toString());
            }
        }
    }

    private void onMessage(String xml) {
        log.debug("onMessage(String) - received message:\n" + xml);
        Object message = this.converter.fromXML(xml);
        log.debug("onMessage(String) - received message of type " + message.getClass().getSimpleName());
        if (message instanceof VisualizerStatusRequest) {
            log.info("Received vsr");
            this.putEvent(TournamentEvent.VSR);
        } else if (!(message instanceof BrokerAccept) && !(message instanceof BrokerAuthentication)) {
            try {
                this.putMessage(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void putMessage(Object message) {
        try {
            this.messageQueue.put(message);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Scheduled(fixedRate=30000L)
    public void addTick() {
        if (!this.eventQueue.contains(TournamentEvent.TICK)) {
            this.putEvent(TournamentEvent.TICK);
        }
    }
}

