/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest.errors;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.powertac.visualizer.web.rest.errors.BadRequestAlertException;
import org.powertac.visualizer.web.rest.errors.ErrorConstants;
import org.powertac.visualizer.web.rest.errors.FieldErrorVM;
import org.powertac.visualizer.web.rest.util.HeaderUtil;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.web.advice.ProblemHandling;
import org.zalando.problem.violations.ConstraintViolationProblem;

@ControllerAdvice
public class ExceptionTranslator
implements ProblemHandling {
    public ResponseEntity<Problem> process(@Nullable ResponseEntity<Problem> entity, NativeWebRequest request) {
        if (entity == null) {
            return entity;
        }
        Problem problem = (Problem)entity.getBody();
        if (!(problem instanceof ConstraintViolationProblem) && !(problem instanceof DefaultProblem)) {
            return entity;
        }
        ProblemBuilder builder = Problem.builder().withType(Problem.DEFAULT_TYPE.equals(problem.getType()) ? ErrorConstants.DEFAULT_TYPE : problem.getType()).withStatus(problem.getStatus()).withTitle(problem.getTitle()).with("path", (Object)((HttpServletRequest)request.getNativeRequest(HttpServletRequest.class)).getRequestURI());
        if (problem instanceof ConstraintViolationProblem) {
            builder.with("violations", (Object)((ConstraintViolationProblem)problem).getViolations()).with("message", (Object)"error.validation");
        } else {
            builder.withCause(((DefaultProblem)problem).getCause()).withDetail(problem.getDetail()).withInstance(problem.getInstance());
            problem.getParameters().forEach((arg_0, arg_1) -> ((ProblemBuilder)builder).with(arg_0, arg_1));
            if (!problem.getParameters().containsKey("message") && problem.getStatus() != null) {
                builder.with("message", (Object)("error.http." + problem.getStatus().getStatusCode()));
            }
        }
        return new ResponseEntity((Object)builder.build(), (MultiValueMap)entity.getHeaders(), entity.getStatusCode());
    }

    public ResponseEntity<Problem> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, @Nonnull NativeWebRequest request) {
        BindingResult result = ex.getBindingResult();
        List fieldErrors = result.getFieldErrors().stream().map(f -> new FieldErrorVM(f.getObjectName(), f.getField(), f.getCode())).collect(Collectors.toList());
        ThrowableProblem problem = Problem.builder().withType(ErrorConstants.CONSTRAINT_VIOLATION_TYPE).withTitle("Method argument not valid").withStatus(this.defaultConstraintViolationStatus()).with("message", (Object)"error.validation").with("fieldErrors", fieldErrors).build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleNoSuchElementException(NoSuchElementException ex, NativeWebRequest request) {
        ThrowableProblem problem = Problem.builder().withStatus((StatusType)Status.NOT_FOUND).with("message", (Object)ErrorConstants.ENTITY_NOT_FOUND_TYPE).build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleBadRequestAlertException(BadRequestAlertException ex, NativeWebRequest request) {
        return this.create((ThrowableProblem)ex, request, HeaderUtil.createFailureAlert((String)ex.getEntityName(), (String)ex.getErrorKey(), (String)ex.getMessage()));
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleConcurrencyFailure(ConcurrencyFailureException ex, NativeWebRequest request) {
        ThrowableProblem problem = Problem.builder().withStatus((StatusType)Status.CONFLICT).with("message", (Object)"error.concurrencyFailure").build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }
}

