/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.List;
import org.powertac.common.CustomerInfo;
import org.powertac.visualizer.domain.RetailKPIHolder;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class Customer {
    private static long idCounter = 0L;
    private long id = idCounter++;
    private long idCustomerInfo;
    private String name;
    private int population;
    private String powerType;
    private double controllableKW;
    private double upRegulationKW;
    private double downRegulationKW;
    private double storageCapacity;
    private boolean multiContracting = false;
    private boolean canNegotiate = false;
    private String genericPowerType;
    @JsonIgnore
    private List<Double> bootstrapNetUsage;
    private RetailKPIHolder retail = new RetailKPIHolder();
    private String customerClass;

    public Customer() {
    }

    public Customer(CustomerInfo info) {
        this.idCustomerInfo = info.getId();
        this.name = info.getName();
        this.population = info.getPopulation();
        this.powerType = info.getPowerType().toString();
        this.controllableKW = info.getControllableKW();
        this.upRegulationKW = info.getUpRegulationKW();
        this.downRegulationKW = info.getDownRegulationKW();
        this.storageCapacity = info.getStorageCapacity();
        this.multiContracting = info.isMultiContracting();
        this.canNegotiate = info.isCanNegotiate();
        this.genericPowerType = info.getPowerType().getGenericType().toString();
        if (info.getCustomerClass() != null) {
            this.customerClass = info.getCustomerClass().toString();
        }
    }

    public long getId() {
        return this.id;
    }

    public long getIdCustomerInfo() {
        return this.idCustomerInfo;
    }

    public String getCustomerClass() {
        return this.customerClass;
    }

    public String getName() {
        return this.name;
    }

    public int getPopulation() {
        return this.population;
    }

    public String getPowerType() {
        return this.powerType;
    }

    public double getControllableKW() {
        return this.controllableKW;
    }

    public double getUpRegulationKW() {
        return this.upRegulationKW;
    }

    public double getDownRegulationKW() {
        return this.downRegulationKW;
    }

    public double getStorageCapacity() {
        return this.storageCapacity;
    }

    public boolean isMultiContracting() {
        return this.multiContracting;
    }

    public boolean isCanNegotiate() {
        return this.canNegotiate;
    }

    public String getGenericPowerType() {
        return this.genericPowerType;
    }

    public List<Double> getBootstrapNetUsage() {
        return this.bootstrapNetUsage;
    }

    public void setBootstrapNetUsage(List<Double> bootstrapNetUsage) {
        this.bootstrapNetUsage = bootstrapNetUsage;
    }

    public RetailKPIHolder getRetail() {
        return this.retail;
    }

    public void setRetail(RetailKPIHolder retailKPIHolder) {
        this.retail = retailKPIHolder;
    }

    public static void recycle() {
        idCounter = 0L;
    }
}

