/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.powertac.common.MarketTransaction;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class WholesaleKPIHolder {
    @JsonIgnore
    private TreeMap<Integer, LinkedList<MarketTransaction>> mtxs = null;
    @JsonIgnore
    private LinkedList<Integer> remove = null;
    @JsonProperty(value="m")
    private double money = 0.0;
    @JsonProperty(value="mwh")
    private double mwh = 0.0;
    @JsonProperty(value="p")
    private double price = Double.NaN;
    @JsonProperty(value="pb")
    private double priceBuy = Double.NaN;
    @JsonProperty(value="ps")
    private double priceSell = Double.NaN;
    @JsonIgnore
    private boolean empty;

    public WholesaleKPIHolder() {
        this.mtxs = new TreeMap();
        this.remove = new LinkedList();
    }

    public WholesaleKPIHolder(WholesaleKPIHolder persist, int timeslot) {
        double total = 0.0;
        double totalBuy = 0.0;
        double totalSell = 0.0;
        this.mwh = 0.0;
        this.money = 0.0;
        this.price = 0.0;
        this.priceBuy = 0.0;
        this.priceSell = 0.0;
        this.empty = true;
        for (Map.Entry e : persist.mtxs.entrySet()) {
            Integer slot = (Integer)e.getKey();
            if (slot < timeslot) {
                persist.remove.add(slot);
                continue;
            }
            if (slot != timeslot) break;
            persist.remove.add(slot);
            for (MarketTransaction mtx : (LinkedList)e.getValue()) {
                double m = mtx.getMWh();
                double p = mtx.getPrice();
                if (m < 0.0) {
                    total -= m;
                    totalSell -= m;
                    this.priceSell -= m * p;
                    this.money -= m * p;
                } else if (m > 0.0) {
                    total += m;
                    totalBuy += m;
                    this.priceBuy -= m * p;
                    this.money += m * p;
                }
                this.mwh += m;
                this.price -= m * p;
            }
            if (total > 0.0) {
                this.price /= total;
                this.empty = false;
                this.priceBuy = totalBuy > 0.0 ? (this.priceBuy /= totalBuy) : Double.NaN;
                if (totalSell > 0.0) {
                    this.priceSell /= totalSell;
                    continue;
                }
                this.priceSell = Double.NaN;
                continue;
            }
            this.price = Double.NaN;
        }
    }

    public void resetCurrentValues() {
        for (Integer slot : this.remove) {
            this.mtxs.remove(slot);
        }
        this.remove.clear();
    }

    public void addTransaction(MarketTransaction mtx) {
        Integer timeslot = mtx.getTimeslotIndex();
        LinkedList<MarketTransaction> list = (LinkedList<MarketTransaction>)this.mtxs.get(timeslot);
        if (list == null) {
            list = new LinkedList<MarketTransaction>();
            this.mtxs.put(timeslot, list);
        }
        list.add(mtx);
    }

    public double getMwh() {
        return this.mwh;
    }

    public double getPrice() {
        return this.price;
    }

    public double getCash() {
        return this.money;
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

