/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service;

import java.time.LocalDate;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.powertac.visualizer.domain.Authority;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.repository.AuthorityRepository;
import org.powertac.visualizer.repository.PersistentTokenRepository;
import org.powertac.visualizer.repository.UserRepository;
import org.powertac.visualizer.security.SecurityUtils;
import org.powertac.visualizer.service.dto.UserDTO;
import org.powertac.visualizer.service.util.RandomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserService {
    private final Logger log = LoggerFactory.getLogger(UserService.class);
    private final UserRepository userRepository;
    private final PasswordEncoder passwordEncoder;
    private final PersistentTokenRepository persistentTokenRepository;
    private final AuthorityRepository authorityRepository;

    public UserService(UserRepository userRepository, PasswordEncoder passwordEncoder, PersistentTokenRepository persistentTokenRepository, AuthorityRepository authorityRepository) {
        this.userRepository = userRepository;
        this.passwordEncoder = passwordEncoder;
        this.persistentTokenRepository = persistentTokenRepository;
        this.authorityRepository = authorityRepository;
    }

    public User createUser(String login, String password, String firstName, String lastName, String langKey) {
        User newUser = new User();
        Authority authority = (Authority)this.authorityRepository.getOne((Object)"ROLE_USER");
        HashSet<Authority> authorities = new HashSet<Authority>();
        String encryptedPassword = this.passwordEncoder.encode((CharSequence)password);
        newUser.setLogin(login);
        newUser.setPassword(encryptedPassword);
        newUser.setFirstName(firstName);
        newUser.setLastName(lastName);
        newUser.setLangKey(langKey);
        authorities.add(authority);
        newUser.setAuthorities(authorities);
        this.userRepository.save((Object)newUser);
        this.log.debug("Created Information for User: {}", (Object)newUser);
        return newUser;
    }

    public User createUser(UserDTO userDTO) {
        User user = new User();
        user.setLogin(userDTO.getLogin());
        user.setFirstName(userDTO.getFirstName());
        user.setLastName(userDTO.getLastName());
        if (userDTO.getLangKey() == null) {
            user.setLangKey("en");
        } else {
            user.setLangKey(userDTO.getLangKey());
        }
        if (userDTO.getAuthorities() != null) {
            HashSet authorities = new HashSet();
            userDTO.getAuthorities().forEach(authority -> authorities.add((Authority)this.authorityRepository.getOne(authority)));
            user.setAuthorities(authorities);
        }
        String encryptedPassword = this.passwordEncoder.encode((CharSequence)RandomUtil.generatePassword());
        user.setPassword(encryptedPassword);
        this.userRepository.save((Object)user);
        this.log.debug("Created Information for User: {}", (Object)user);
        return user;
    }

    public void updateUser(String firstName, String lastName, String langKey) {
        this.userRepository.findOneByLogin(SecurityUtils.getCurrentUserLogin()).ifPresent(user -> {
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setLangKey(langKey);
            this.log.debug("Changed Information for User: {}", user);
        });
    }

    public Optional<UserDTO> updateUser(UserDTO userDTO) {
        return Optional.of((User)this.userRepository.getOne((Object)userDTO.getId())).map(user -> {
            user.setLogin(userDTO.getLogin());
            user.setFirstName(userDTO.getFirstName());
            user.setLastName(userDTO.getLastName());
            user.setLangKey(userDTO.getLangKey());
            Set managedAuthorities = user.getAuthorities();
            managedAuthorities.clear();
            userDTO.getAuthorities().stream().map(arg_0 -> ((AuthorityRepository)this.authorityRepository).getOne(arg_0)).forEach(managedAuthorities::add);
            this.log.debug("Changed Information for User: {}", user);
            return user;
        }).map(UserDTO::new);
    }

    public void deleteUser(String login) {
        this.userRepository.findOneByLogin(login).ifPresent(user -> {
            this.userRepository.delete(user);
            this.log.debug("Deleted User: {}", user);
        });
    }

    public void changePassword(String password) {
        this.userRepository.findOneByLogin(SecurityUtils.getCurrentUserLogin()).ifPresent(user -> {
            String encryptedPassword = this.passwordEncoder.encode((CharSequence)password);
            user.setPassword(encryptedPassword);
            this.log.debug("Changed password for User: {}", user);
        });
    }

    @Transactional(readOnly=true)
    public Page<UserDTO> getAllManagedUsers(Pageable pageable) {
        return this.userRepository.findAllByLoginNot(pageable, "anonymoususer").map(UserDTO::new);
    }

    @Transactional(readOnly=true)
    public Optional<User> getUserByLogin(String login) {
        return this.userRepository.findOneByLogin(login);
    }

    @Transactional(readOnly=true)
    public Optional<User> getUserWithAuthoritiesByLogin(String login) {
        return this.userRepository.findOneWithAuthoritiesByLogin(login);
    }

    @Transactional(readOnly=true)
    public User getUserWithAuthorities(Long id) {
        return this.userRepository.findOneWithAuthoritiesById(id);
    }

    @Transactional(readOnly=true)
    public User getUserWithAuthorities() {
        return this.userRepository.findOneWithAuthoritiesByLogin(SecurityUtils.getCurrentUserLogin()).orElse(null);
    }

    @Scheduled(cron="0 0 0 * * ?")
    public void removeOldPersistentTokens() {
        LocalDate now = LocalDate.now();
        this.persistentTokenRepository.findByTokenDateBefore(now.minusMonths(1L)).forEach(token -> {
            this.log.debug("Deleting token {}", (Object)token.getSeries());
            User user = token.getUser();
            user.getPersistentTokens().remove(token);
            this.persistentTokenRepository.delete(token);
        });
    }
}

