/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest;

import io.github.jhipster.web.util.ResponseUtil;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.powertac.visualizer.service.AuditEventService;
import org.powertac.visualizer.web.rest.util.PaginationUtil;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/management/audits"})
public class AuditResource {
    private final AuditEventService auditEventService;

    public AuditResource(AuditEventService auditEventService) {
        this.auditEventService = auditEventService;
    }

    @GetMapping
    public ResponseEntity<List<AuditEvent>> getAll(Pageable pageable) throws URISyntaxException {
        Page page = this.auditEventService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((Page)page, (String)"/management/audits");
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(params={"fromDate", "toDate"})
    public ResponseEntity<List<AuditEvent>> getByDates(@RequestParam(value="fromDate") LocalDate fromDate, @RequestParam(value="toDate") LocalDate toDate, Pageable pageable) throws URISyntaxException {
        Page page = this.auditEventService.findByDates(fromDate.atTime(0, 0), toDate.atTime(23, 59), pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((Page)page, (String)"/management/audits");
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/{id:.+}"})
    public ResponseEntity<AuditEvent> get(@PathVariable Long id) {
        return ResponseUtil.wrapOrNotFound((Optional)this.auditEventService.find(id));
    }
}

