/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest;

import com.codahale.metrics.annotation.Timed;
import io.github.jhipster.web.util.ResponseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.IOUtils;
import org.powertac.visualizer.domain.Game;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.domain.enumeration.FileType;
import org.powertac.visualizer.repository.UserRepository;
import org.powertac.visualizer.security.SecurityUtils;
import org.powertac.visualizer.service.FileService;
import org.powertac.visualizer.service.GameService;
import org.powertac.visualizer.service_ptac.SyncFilesService;
import org.powertac.visualizer.web.rest.FileResource;
import org.powertac.visualizer.web.rest.util.HeaderUtil;
import org.powertac.visualizer.web.rest.util.PaginationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class FileResource {
    private final Logger log = LoggerFactory.getLogger(FileResource.class);
    private static final String ENTITY_NAME = "file";
    private final FileService fileService;
    private final GameService gameService;
    private final UserRepository userRepository;
    @Autowired
    private SyncFilesService syncFilesService;

    public FileResource(FileService fileService, GameService gameService, UserRepository userRepository) {
        this.fileService = fileService;
        this.gameService = gameService;
        this.userRepository = userRepository;
    }

    @PostMapping(value={"/files"})
    @Timed
    public ResponseEntity<org.powertac.visualizer.domain.File> createFile(@Valid @RequestBody org.powertac.visualizer.domain.File file) throws URISyntaxException {
        this.log.debug("REST request to save File : {}", (Object)file);
        if (file.getId() != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(HeaderUtil.createFailureAlert((String)ENTITY_NAME, (String)"idexists", (String)"A new file cannot already have an ID"))).body(null);
        }
        String login = SecurityUtils.getCurrentUserLogin();
        User user = this.userRepository.findOneByLogin(login).orElse(null);
        file.setOwner(user);
        org.powertac.visualizer.domain.File result = this.fileService.save(file);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/files/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/files"})
    @Timed
    public ResponseEntity<org.powertac.visualizer.domain.File> updateFile(@Valid @RequestBody org.powertac.visualizer.domain.File file) throws URISyntaxException {
        this.log.debug("REST request to update File : {}", (Object)file);
        if (file.getId() == null) {
            return this.createFile(file);
        }
        org.powertac.visualizer.domain.File result = this.fileService.save(file);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)ENTITY_NAME, (String)file.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/files"})
    @Timed
    public ResponseEntity<List<org.powertac.visualizer.domain.File>> getAllFiles(Pageable pageable) throws URISyntaxException {
        this.log.debug("REST request to get a page of Files");
        Page page = this.fileService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((Page)page, (String)"/api/files");
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/files/{id}"})
    @Timed
    public ResponseEntity<org.powertac.visualizer.domain.File> getFile(@PathVariable Long id) {
        this.log.debug("REST request to get File : {}", (Object)id);
        Optional file = this.fileService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)file);
    }

    @DeleteMapping(value={"/files/{id}"})
    @Timed
    public ResponseEntity<Void> deleteFile(@PathVariable Long id) {
        this.log.debug("REST request to delete File : {}", (Object)id);
        Optional file = this.fileService.findOne(id);
        if (file.isPresent()) {
            org.powertac.visualizer.domain.File ff = (org.powertac.visualizer.domain.File)file.get();
            this.fileService.delete(ff);
            ff.getType().getFile(ff.getOwner(), ff.getName()).delete();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityDeletionAlert((String)ENTITY_NAME, (String)id.toString()))).build();
    }

    @GetMapping(value={"/myfiles/{type}/"})
    @Timed
    public ResponseEntity<List<org.powertac.visualizer.domain.File>> getMyFiles(@Valid @NotNull @PathVariable String type) throws URISyntaxException {
        this.syncFilesService.syncFileSystem();
        FileType fileType = FileType.valueOf((String)type.toUpperCase());
        this.log.debug("REST request to get owned and shared files, type = " + type);
        String login = SecurityUtils.getCurrentUserLogin();
        List list = this.fileService.findByOwnerIsCurrentUserOrShared(login, fileType);
        return new ResponseEntity((Object)list, HttpStatus.OK);
    }

    @GetMapping(value={"/myfiles/{type}/{id}"})
    @Timed
    public void getMyFile(@Valid @NotNull @PathVariable String type, @Valid @NotNull @PathVariable Long id, HttpServletResponse response) throws IOException {
        this.log.debug("REST request to download a file");
        FileType fileType = FileType.valueOf((String)type.toUpperCase());
        if (fileType == null) {
            throw new IllegalArgumentException("Unknown type " + type);
        }
        Optional file = this.fileService.findOne(id);
        if (file.isEmpty()) {
            return;
        }
        org.powertac.visualizer.domain.File ff = (org.powertac.visualizer.domain.File)file.get();
        File raw = fileType.getFile(ff.getOwner(), ff.getName());
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(raw));
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            response.setHeader("Content-Disposition", "attachment; filename=" + ff.getName());
            response.setHeader("Content-Type", fileType.getContentType());
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    @PostMapping(value={"/myfiles/{type}/"})
    @Timed
    public ResponseEntity<org.powertac.visualizer.domain.File> postFile(@Valid @NotNull @PathVariable String type, @RequestParam(value="shared") Boolean shared, @RequestParam(value="overwrite") Boolean overwrite, @Valid @NotNull @RequestParam(value="file") MultipartFile part) throws IOException, URISyntaxException {
        String name = part.getOriginalFilename();
        this.log.debug("REST request to upload a " + type.toString() + " file: " + name + " @ " + part.getSize() + " bytes.");
        String login = SecurityUtils.getCurrentUserLogin();
        User user = this.userRepository.findOneByLogin(login).orElse(null);
        FileType fileType = FileType.valueOf((String)type.toUpperCase());
        File raw = fileType.getFile(user, name);
        if (raw.exists()) {
            if (overwrite.booleanValue()) {
                List files = this.fileService.findByOwnerIsCurrentUser(login, fileType);
                for (org.powertac.visualizer.domain.File file : files) {
                    if (!file.getName().equals(name)) continue;
                    for (Game game : this.gameService.findByAssociatedFile(file)) {
                        switch (1.$SwitchMap$org$powertac$visualizer$domain$enumeration$FileType[fileType.ordinal()]) {
                            case 1: {
                                game.setBootFile(null);
                                break;
                            }
                            case 2: {
                                game.setConfigFile(null);
                                break;
                            }
                            case 3: {
                                game.setSeedFile(null);
                                break;
                            }
                            case 4: {
                                game.setWeatherFile(null);
                                break;
                            }
                            case 5: {
                                game.setStateFile(null);
                                break;
                            }
                            case 6: {
                                game.setTraceFile(null);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Can't overwrite " + type + " file");
                            }
                        }
                        this.gameService.save(game);
                    }
                    this.fileService.delete(file);
                    break;
                }
            } else {
                throw new FileExistsException();
            }
        }
        try (FileOutputStream out = new FileOutputStream(raw);){
            ResponseEntity responseEntity;
            block26: {
                InputStream in = part.getInputStream();
                try {
                    int len;
                    byte[] buf = new byte[65536];
                    while ((len = in.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    org.powertac.visualizer.domain.File file = new org.powertac.visualizer.domain.File();
                    file.setType(fileType);
                    file.setName(name);
                    file.setOwner(user);
                    file.setShared(shared);
                    file = this.fileService.save(file);
                    responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/files/" + file.getId())).headers(HeaderUtil.createEntityCreationAlert((String)ENTITY_NAME, (String)file.getId().toString()))).body((Object)file);
                    if (in == null) break block26;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return responseEntity;
        }
    }
}

