/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Proxy;
import org.powertac.visualizer.domain.Graph;
import org.powertac.visualizer.domain.User;

@Entity
@Table(name="chart")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Proxy(lazy=false)
public class Chart
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @Size(min=1, max=255)
    @Column(name="name", length=255, nullable=false)
    private @NotNull @Size(min=1, max=255) String name;
    @NotNull
    @Column(name="shared", nullable=false)
    private Boolean shared;
    @ManyToOne
    private User owner;
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @JoinTable(name="chart_graph", joinColumns={@JoinColumn(name="charts_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="graphs_id", referencedColumnName="id")})
    private Set<Graph> graphs = new HashSet();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean isShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User user) {
        this.owner = user;
    }

    public Set<Graph> getGraphs() {
        return this.graphs;
    }

    public void setGraphs(Set<Graph> graphs) {
        this.graphs = graphs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chart chart = (Chart)o;
        if (chart.id == null || this.id == null) {
            return false;
        }
        return Objects.equals(this.id, chart.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "Chart{id=" + this.id + ", name='" + this.name + "', shared='" + this.shared + "'}";
    }
}

