/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.repository;

import java.util.List;
import org.powertac.visualizer.domain.File;
import org.powertac.visualizer.domain.Game;
import org.powertac.visualizer.domain.enumeration.GameType;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface GameRepository
extends JpaRepository<Game, Long> {
    @Query(value="select game from Game game where game.owner.login = ?#{principal.username}")
    public List<Game> findByOwnerIsCurrentUser();

    @Query(value="select game from Game game where game.owner.login = ?#{principal.username} or game.shared = TRUE")
    public List<Game> findByOwnerIsCurrentUserOrShared();

    @Query(value="select game from Game game where game.shared = TRUE or game.owner.login = :login")
    public List<Game> findByOwnerIsCurrentUserOrShared(@Param(value="login") String var1);

    @Query(value="select game from Game game where (game.owner.login = ?#{principal.username} or game.shared = TRUE) and game.name = ?1 and game.type = ?2")
    public List<Game> findByNameAndType(String var1, GameType var2);

    @Query(value="select game from Game game where (game.shared = TRUE or game.owner.login = :login) and game.name = :name and game.type = :type")
    public List<Game> findByNameAndType(@Param(value="login") String var1, @Param(value="name") String var2, @Param(value="type") GameType var3);

    @Query(value="select game from Game game where game.traceFile = ?1 or game.stateFile = ?1 or game.seedFile = ?1 or game.configFile = ?1 or game.bootFile = ?1 or game.weatherFile = ?1")
    public List<Game> findByAssociatedFile(File var1);
}

