/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest;

import com.codahale.metrics.annotation.Timed;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.powertac.visualizer.domain.Chart;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.repository.UserRepository;
import org.powertac.visualizer.security.SecurityUtils;
import org.powertac.visualizer.service.ChartService;
import org.powertac.visualizer.web.rest.util.HeaderUtil;
import org.powertac.visualizer.web.rest.util.PaginationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ChartResource {
    private final Logger log = LoggerFactory.getLogger(ChartResource.class);
    private static final String ENTITY_NAME = "chart";
    private final ChartService chartService;
    private final UserRepository userRepository;

    public ChartResource(ChartService chartService, UserRepository userRepository) {
        this.chartService = chartService;
        this.userRepository = userRepository;
    }

    @PostMapping(value={"/charts"})
    @Timed
    public ResponseEntity<Chart> createChart(@Valid @RequestBody Chart chart) throws URISyntaxException {
        this.log.debug("REST request to save Chart : {}", (Object)chart);
        if (chart.getId() != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(HeaderUtil.createFailureAlert((String)ENTITY_NAME, (String)"idexists", (String)"A new chart cannot already have an ID"))).body(null);
        }
        String login = SecurityUtils.getCurrentUserLogin();
        User user = this.userRepository.findOneByLogin(login).orElse(null);
        chart.setOwner(user);
        Chart result = this.chartService.save(chart);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/charts/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/charts"})
    @Timed
    public ResponseEntity<Chart> updateChart(@Valid @RequestBody Chart chart) throws URISyntaxException {
        this.log.debug("REST request to update Chart : {}", (Object)chart);
        if (chart.getId() == null) {
            return this.createChart(chart);
        }
        Chart result = this.chartService.save(chart);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)ENTITY_NAME, (String)chart.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/charts"})
    @Timed
    public ResponseEntity<List<Chart>> getAllCharts(Pageable pageable) throws URISyntaxException {
        this.log.debug("REST request to get a page of Charts");
        Page page = this.chartService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((Page)page, (String)"/api/charts");
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/charts/{id}"})
    @Timed
    public ResponseEntity<Chart> getChart(@PathVariable Long id) {
        this.log.debug("REST request to get Chart : {}", (Object)id);
        Optional chart = this.chartService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)chart);
    }

    @DeleteMapping(value={"/charts/{id}"})
    @Timed
    public ResponseEntity<Void> deleteChart(@PathVariable Long id) {
        this.log.debug("REST request to delete Chart : {}", (Object)id);
        Optional chart = this.chartService.findOne(id);
        chart.ifPresent(arg_0 -> ((ChartService)this.chartService).delete(arg_0));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityDeletionAlert((String)ENTITY_NAME, (String)id.toString()))).build();
    }

    @GetMapping(value={"/mycharts"})
    @Timed
    public ResponseEntity<List<Chart>> getMyGames() throws URISyntaxException {
        this.log.debug("REST request to get owned and shared charts");
        String login = SecurityUtils.getCurrentUserLogin();
        List list = this.chartService.findByOwnerIsCurrentUserOrShared(login);
        return new ResponseEntity((Object)list, HttpStatus.OK);
    }
}

