/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.websocket;

import org.powertac.visualizer.domain.TickSnapshot;
import org.powertac.visualizer.repository_ptac.BrokerRepository;
import org.powertac.visualizer.repository_ptac.CustomerRepository;
import org.powertac.visualizer.repository_ptac.TickSnapshotRepository;
import org.powertac.visualizer.service_ptac.CompetitionService;
import org.powertac.visualizer.service_ptac.VisualizerService;
import org.powertac.visualizer.web.dto.InitMessage;
import org.powertac.visualizer.web.dto.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.stereotype.Controller;

@Controller
public class Pusher {
    private static final String TOPIC_MESSAGE = "/topic/push";
    @Autowired
    private SimpMessageSendingOperations messagingTemplate;
    @Autowired
    private VisualizerService visualizerService;
    @Autowired
    private BrokerRepository brokerRepository;
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private TickSnapshotRepository tickSnapshotRepository;
    @Autowired
    private CompetitionService currentCompetition;

    @SubscribeMapping(value={"/topic/push"})
    public Message pusherInit() {
        return new Message(Message.Type.INIT, this.currentCompetition.getName(), (Object)new InitMessage(this.visualizerService.getState(), this.currentCompetition, this.brokerRepository.findAll(), this.customerRepository.findAll(), this.tickSnapshotRepository.findAll()));
    }

    public void sendInitMessage(InitMessage initMessage) {
        this.messagingTemplate.convertAndSend((Object)TOPIC_MESSAGE, (Object)new Message(Message.Type.INIT, this.currentCompetition.getName(), (Object)initMessage));
    }

    public void sendTickSnapshotUpdates(TickSnapshot payload) {
        this.messagingTemplate.convertAndSend((Object)TOPIC_MESSAGE, (Object)new Message(Message.Type.DATA, this.currentCompetition.getName(), (Object)payload));
    }

    public void sendGameStatusMessage(VisualizerService.VisualizerState status) {
        this.messagingTemplate.convertAndSend((Object)TOPIC_MESSAGE, (Object)new Message(Message.Type.INFO, this.currentCompetition.getName(), (Object)status));
    }
}

