/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.config;

import io.github.jhipster.config.JHipsterProperties;
import io.github.jhipster.security.AjaxAuthenticationFailureHandler;
import io.github.jhipster.security.AjaxAuthenticationSuccessHandler;
import io.github.jhipster.security.AjaxLogoutSuccessHandler;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.data.repository.query.SecurityEvaluationContextExtension;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.web.filter.CorsFilter;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;

@Import(value={SecurityProblemSupport.class})
@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private final AuthenticationManagerBuilder authenticationManagerBuilder;
    private final UserDetailsService userDetailsService;
    private final JHipsterProperties jHipsterProperties;
    private final RememberMeServices rememberMeServices;
    private final CorsFilter corsFilter;
    private final SecurityProblemSupport problemSupport;

    public SecurityConfiguration(AuthenticationManagerBuilder authenticationManagerBuilder, UserDetailsService userDetailsService, JHipsterProperties jHipsterProperties, RememberMeServices rememberMeServices, CorsFilter corsFilter, SecurityProblemSupport problemSupport) {
        this.authenticationManagerBuilder = authenticationManagerBuilder;
        this.userDetailsService = userDetailsService;
        this.jHipsterProperties = jHipsterProperties;
        this.rememberMeServices = rememberMeServices;
        this.corsFilter = corsFilter;
        this.problemSupport = problemSupport;
    }

    @PostConstruct
    public void init() {
        try {
            this.authenticationManagerBuilder.userDetailsService(this.userDetailsService).passwordEncoder(this.passwordEncoder());
        }
        catch (Exception e) {
            throw new BeanInitializationException("Security configuration failed", (Throwable)e);
        }
    }

    @Bean
    public AjaxAuthenticationSuccessHandler ajaxAuthenticationSuccessHandler() {
        return new AjaxAuthenticationSuccessHandler();
    }

    @Bean
    public AjaxAuthenticationFailureHandler ajaxAuthenticationFailureHandler() {
        return new AjaxAuthenticationFailureHandler();
    }

    @Bean
    public AjaxLogoutSuccessHandler ajaxLogoutSuccessHandler() {
        return new AjaxLogoutSuccessHandler();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/app/**/*.{js,html}"})).antMatchers(new String[]{"/bower_components/**"})).antMatchers(new String[]{"/i18n/**"})).antMatchers(new String[]{"/content/**"})).antMatchers(new String[]{"/test/**"})).antMatchers(new String[]{"/h2-console/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).and()).addFilterBefore((Filter)this.corsFilter, CsrfFilter.class).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.problemSupport).accessDeniedHandler((AccessDeniedHandler)this.problemSupport).and()).rememberMe().rememberMeServices(this.rememberMeServices).rememberMeParameter("remember-me").key(this.jHipsterProperties.getSecurity().getRememberMe().getKey()).and()).formLogin().loginProcessingUrl("/api/authentication")).successHandler((AuthenticationSuccessHandler)this.ajaxAuthenticationSuccessHandler())).failureHandler((AuthenticationFailureHandler)this.ajaxAuthenticationFailureHandler())).usernameParameter("j_username").passwordParameter("j_password").permitAll()).and()).logout().logoutUrl("/api/logout").logoutSuccessHandler((LogoutSuccessHandler)this.ajaxLogoutSuccessHandler()).permitAll().and()).headers().frameOptions().disable().and()).authorizeRequests().antMatchers(new String[]{"/api/register"})).permitAll().antMatchers(new String[]{"/api/activate"})).permitAll().antMatchers(new String[]{"/api/authenticate"})).permitAll().antMatchers(new String[]{"/api/account/reset_password/init"})).permitAll().antMatchers(new String[]{"/api/account/reset_password/finish"})).permitAll().antMatchers(new String[]{"/api/profile-info"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/*graphs/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/*charts/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/*views/**"})).permitAll().antMatchers(new String[]{"/api/**"})).authenticated().antMatchers(new String[]{"/websocket/tracker"})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/websocket/**"})).permitAll().antMatchers(new String[]{"/management/health"})).permitAll().antMatchers(new String[]{"/management/**"})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/v2/api-docs/**"})).permitAll();
    }

    @Bean
    public SecurityEvaluationContextExtension securityEvaluationContextExtension() {
        return new SecurityEvaluationContextExtension();
    }
}

