/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.config;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.servlet.InstrumentedFilter;
import com.codahale.metrics.servlets.MetricsServlet;
import io.github.jhipster.config.JHipsterProperties;
import io.github.jhipster.web.filter.CachingHttpHeadersFilter;
import java.io.File;
import java.nio.file.Paths;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.StandardRoot;
import org.h2.server.web.WebServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
public class WebConfigurer
implements ServletContextInitializer,
WebServerFactoryCustomizer<WebServerFactory> {
    private final Logger log = LoggerFactory.getLogger(WebConfigurer.class);
    private final Environment env;
    private final JHipsterProperties jHipsterProperties;
    private MetricRegistry metricRegistry;

    public WebConfigurer(Environment env, JHipsterProperties jHipsterProperties) {
        this.env = env;
        this.jHipsterProperties = jHipsterProperties;
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        if (this.env.getActiveProfiles().length != 0) {
            this.log.info("Web application configuration, using profiles: {}", (Object[])this.env.getActiveProfiles());
        }
        EnumSet<DispatcherType> disps = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC);
        this.initMetrics(servletContext, disps);
        if (this.env.acceptsProfiles(new String[]{"prod"})) {
            this.initCachingHttpHeadersFilter(servletContext, disps);
        }
        if (this.env.acceptsProfiles(new String[]{"dev"})) {
            this.initH2Console(servletContext);
        }
        this.log.info("Web application fully configured");
    }

    public void customize(WebServerFactory server) {
        if (server instanceof ConfigurableWebServerFactory) {
            MimeMappings mappings = new MimeMappings(MimeMappings.DEFAULT);
            mappings.add("html", "text/html;charset=utf-8");
            mappings.add("json", "text/html;charset=utf-8");
            ConfigurableServletWebServerFactory container = (ConfigurableServletWebServerFactory)server;
            container.setMimeMappings(mappings);
            this.customizeTomcat(container);
            this.setLocationForStaticAssets(container);
        }
    }

    private void customizeTomcat(ConfigurableServletWebServerFactory container) {
        if (container instanceof ConfigurableTomcatWebServerFactory) {
            ConfigurableTomcatWebServerFactory tomcatFactory = (ConfigurableTomcatWebServerFactory)container;
            tomcatFactory.addContextCustomizers(new TomcatContextCustomizer[]{context -> {
                StandardRoot resources = new StandardRoot();
                resources.setCacheMaxSize(65536L);
                resources.setCacheObjectMaxSize(1024);
                context.setResources((WebResourceRoot)resources);
            }});
        }
    }

    private void setLocationForStaticAssets(ConfigurableServletWebServerFactory container) {
        String prefixPath = this.resolvePathPrefix();
        File root = this.env.acceptsProfiles(new String[]{"prod"}) ? new File(prefixPath + "target/www/") : new File(prefixPath + "src/main/webapp/");
        if (root.exists() && root.isDirectory()) {
            container.setDocumentRoot(root);
        }
    }

    private String resolvePathPrefix() {
        String rootPath;
        String fullExecutablePath = this.getClass().getResource("").getPath();
        String extractedPath = fullExecutablePath.replace(rootPath = Paths.get(".", new String[0]).toUri().normalize().getPath(), "");
        int extractionEndIndex = extractedPath.indexOf("target/");
        if (extractionEndIndex <= 0) {
            return "";
        }
        return extractedPath.substring(0, extractionEndIndex);
    }

    private void initCachingHttpHeadersFilter(ServletContext servletContext, EnumSet<DispatcherType> disps) {
        this.log.debug("Registering Caching HTTP Headers Filter");
        FilterRegistration.Dynamic cachingHttpHeadersFilter = servletContext.addFilter("cachingHttpHeadersFilter", (Filter)new CachingHttpHeadersFilter(this.jHipsterProperties));
        cachingHttpHeadersFilter.addMappingForUrlPatterns(disps, true, new String[]{"/content/*"});
        cachingHttpHeadersFilter.addMappingForUrlPatterns(disps, true, new String[]{"/app/*"});
        cachingHttpHeadersFilter.setAsyncSupported(true);
    }

    private void initMetrics(ServletContext servletContext, EnumSet<DispatcherType> disps) {
        this.log.debug("Initializing Metrics registries");
        servletContext.setAttribute(InstrumentedFilter.REGISTRY_ATTRIBUTE, (Object)this.metricRegistry);
        servletContext.setAttribute(MetricsServlet.METRICS_REGISTRY, (Object)this.metricRegistry);
        this.log.debug("Registering Metrics Filter");
        FilterRegistration.Dynamic metricsFilter = servletContext.addFilter("webappMetricsFilter", (Filter)new InstrumentedFilter());
        metricsFilter.addMappingForUrlPatterns(disps, true, new String[]{"/*"});
        metricsFilter.setAsyncSupported(true);
        this.log.debug("Registering Metrics Servlet");
        ServletRegistration.Dynamic metricsAdminServlet = servletContext.addServlet("metricsServlet", (Servlet)new MetricsServlet());
        metricsAdminServlet.addMapping(new String[]{"/management/metrics/*"});
        metricsAdminServlet.setAsyncSupported(true);
        metricsAdminServlet.setLoadOnStartup(2);
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = this.jHipsterProperties.getCors();
        if (config.getAllowedOrigins() != null && !config.getAllowedOrigins().isEmpty()) {
            this.log.debug("Registering CORS filter");
            source.registerCorsConfiguration("/api/**", config);
            source.registerCorsConfiguration("/v2/api-docs", config);
        }
        return new CorsFilter((CorsConfigurationSource)source);
    }

    private void initH2Console(ServletContext servletContext) {
        this.log.debug("Initialize H2 console");
        ServletRegistration.Dynamic h2ConsoleServlet = servletContext.addServlet("H2Console", (Servlet)new WebServlet());
        h2ConsoleServlet.addMapping(new String[]{"/h2-console/*"});
        h2ConsoleServlet.setInitParameter("-properties", "src/main/resources/");
        h2ConsoleServlet.setLoadOnStartup(1);
    }

    @Autowired(required=false)
    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }
}

