/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class RetailKPIHolder {
    @JsonProperty(value="sub")
    private int subscribedPopulation;
    private double kwh;
    @JsonProperty(value="m")
    private double money;
    @JsonProperty(value="actTx")
    private int activeTariffs;
    @JsonProperty(value="rvkTx")
    private int revokedTariffs;
    @JsonProperty(value="pubTx")
    private int publishedTariffs;
    @JsonIgnore
    private boolean empty;

    public RetailKPIHolder() {
        this.resetCurrentValues();
    }

    public RetailKPIHolder(RetailKPIHolder retailKPIHolder) {
        this.subscribedPopulation = retailKPIHolder.getSubscribedPopulation();
        this.kwh = retailKPIHolder.getKwh();
        this.money = retailKPIHolder.getMoney();
        this.activeTariffs = retailKPIHolder.getActiveTariffs();
        this.revokedTariffs = retailKPIHolder.getRevokedTariffs();
        this.publishedTariffs = retailKPIHolder.getPublishedTariffs();
        this.empty = retailKPIHolder.empty;
    }

    public void resetCurrentValues() {
        this.subscribedPopulation = 0;
        this.kwh = 0.0;
        this.money = 0.0;
        this.revokedTariffs = 0;
        this.publishedTariffs = 0;
        this.empty = true;
    }

    public void signup(int population) {
        this.subscribedPopulation += population;
        this.empty = this.empty && this.subscribedPopulation == 0;
    }

    public void withdraw(int population) {
        this.subscribedPopulation -= population;
        this.empty = this.empty && this.subscribedPopulation == 0;
    }

    public void produceConsume(double txKwh, double txMoney) {
        this.kwh += txKwh;
        this.money += txMoney;
        this.empty = this.empty && this.kwh == 0.0 && this.money == 0.0;
    }

    public void incrementRevokedTariffs() {
        ++this.revokedTariffs;
        this.empty = false;
    }

    public void incrementPublishedTariffs() {
        ++this.publishedTariffs;
        this.empty = false;
    }

    public int getSubscribedPopulation() {
        return this.subscribedPopulation;
    }

    public void setSubscribedPopulation(int population) {
        this.subscribedPopulation = population;
        this.empty = this.empty && this.subscribedPopulation == 0;
    }

    public double getKwh() {
        return this.kwh;
    }

    public void setKwh(double kwh) {
        this.kwh = kwh;
        this.empty = this.empty && kwh == 0.0;
    }

    public Double getMoney() {
        return this.money;
    }

    public void setMoney(double money) {
        this.money = money;
        this.empty = this.empty && money == 0.0;
    }

    public int getActiveTariffs() {
        return this.activeTariffs;
    }

    public void setActiveTariffs(int activeTariffs) {
        this.activeTariffs = activeTariffs;
        this.empty = this.empty && activeTariffs == 0;
    }

    public int getRevokedTariffs() {
        return this.revokedTariffs;
    }

    public void setRevokedTariffs(int revokedTariffs) {
        this.revokedTariffs = revokedTariffs;
        this.empty = this.empty && revokedTariffs == 0;
    }

    public int getPublishedTariffs() {
        return this.publishedTariffs;
    }

    public void setPublishedTariffs(int publishedTariffs) {
        this.publishedTariffs = publishedTariffs;
        this.empty = this.empty && publishedTariffs == 0;
    }

    public String toString() {
        return "RetailKPIHolder [subscribedPopulationCum=, subscribedPopulation=" + this.subscribedPopulation + ", kwh=" + this.kwh + ", money=" + this.money + "]";
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

