/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service;

import java.time.LocalDateTime;
import java.util.Optional;
import org.powertac.visualizer.config.audit.AuditEventConverter;
import org.powertac.visualizer.repository.PersistenceAuditEventRepository;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuditEventService {
    private final PersistenceAuditEventRepository persistenceAuditEventRepository;
    private final AuditEventConverter auditEventConverter;

    public AuditEventService(PersistenceAuditEventRepository persistenceAuditEventRepository, AuditEventConverter auditEventConverter) {
        this.persistenceAuditEventRepository = persistenceAuditEventRepository;
        this.auditEventConverter = auditEventConverter;
    }

    public Page<AuditEvent> findAll(Pageable pageable) {
        return this.persistenceAuditEventRepository.findAll(pageable).map(arg_0 -> ((AuditEventConverter)this.auditEventConverter).convertToAuditEvent(arg_0));
    }

    public Page<AuditEvent> findByDates(LocalDateTime fromDate, LocalDateTime toDate, Pageable pageable) {
        return this.persistenceAuditEventRepository.findAllByAuditEventDateBetween(fromDate, toDate, pageable).map(arg_0 -> ((AuditEventConverter)this.auditEventConverter).convertToAuditEvent(arg_0));
    }

    public Optional<AuditEvent> find(Long id) {
        return Optional.ofNullable(this.persistenceAuditEventRepository.findById((Object)id)).filter(Optional::isPresent).map(Optional::get).map(arg_0 -> ((AuditEventConverter)this.auditEventConverter).convertToAuditEvent(arg_0));
    }
}

