/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service;

import java.util.List;
import java.util.Optional;
import org.powertac.visualizer.domain.File;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.domain.enumeration.FileType;
import org.powertac.visualizer.repository.FileRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FileService {
    private final Logger log = LoggerFactory.getLogger(FileService.class);
    private final FileRepository fileRepository;

    public FileService(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    public File save(File file) {
        this.log.debug("Request to save File : {}", (Object)file);
        File result = (File)this.fileRepository.save((Object)file);
        return result;
    }

    @Transactional(readOnly=true)
    public Page<File> findAll(Pageable pageable) {
        this.log.debug("Request to get all Files");
        Page result = this.fileRepository.findAll(pageable);
        return result;
    }

    @Transactional(readOnly=true)
    public List<File> findByOwnerIsCurrentUser(String login, FileType type) {
        this.log.debug("Request to get all owned and shared Files");
        if (type != null && type.equals((Object)FileType.ANY)) {
            type = null;
        }
        List result = this.fileRepository.findByOwnerIsCurrentUser(login, type);
        return result;
    }

    @Transactional(readOnly=true)
    public List<File> findByOwnerIsCurrentUserOrShared(String login, FileType type) {
        this.log.debug("Request to get all owned and shared Files");
        if (type != null && type.equals((Object)FileType.ANY)) {
            type = null;
        }
        List result = this.fileRepository.findByOwnerIsCurrentUserOrShared(login, type);
        return result;
    }

    @Transactional(readOnly=true)
    public Optional<File> findOne(Long id) {
        this.log.debug("Request to get File : {}", (Object)id);
        return this.fileRepository.findById((Object)id);
    }

    public void delete(File file) {
        this.log.debug("Request to delete File : {}", (Object)file);
        this.fileRepository.delete((Object)file);
        file.delete();
    }

    public File createFile(FileType type, String name, User owner) {
        File file = new File();
        file.setType(type);
        file.setName(name);
        file.setOwner(owner);
        file.setShared(Boolean.valueOf(owner.getLogin().equals("system") && !name.startsWith("init.")));
        return this.save(file);
    }
}

