/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.service.dto.UserDTO;
import org.powertac.visualizer.service.mapper.UserMapper;
import org.springframework.stereotype.Component;

@Component
public class UserMapperImpl
implements UserMapper {
    public UserDTO userToUserDTO(User user) {
        Set set;
        if (user == null) {
            return null;
        }
        UserDTO userDTO = new UserDTO();
        userDTO.setId(user.getId());
        userDTO.setLogin(user.getLogin());
        userDTO.setLastModifiedDate(user.getLastModifiedDate());
        if (userDTO.getAuthorities() != null && (set = this.stringsFromAuthorities(user.getAuthorities())) != null) {
            userDTO.getAuthorities().addAll(set);
        }
        return userDTO;
    }

    public List<UserDTO> usersToUserDTOs(List<User> users) {
        if (users == null) {
            return null;
        }
        ArrayList<UserDTO> list = new ArrayList<UserDTO>(users.size());
        for (User user : users) {
            list.add(this.userToUserDTO(user));
        }
        return list;
    }

    public User userDTOToUser(UserDTO userDTO) {
        if (userDTO == null) {
            return null;
        }
        User user = new User();
        user.setId(userDTO.getId());
        user.setLogin(userDTO.getLogin());
        user.setFirstName(userDTO.getFirstName());
        user.setLastName(userDTO.getLastName());
        user.setLangKey(userDTO.getLangKey());
        user.setAuthorities(this.authoritiesFromStrings(userDTO.getAuthorities()));
        return user;
    }

    public List<User> userDTOsToUsers(List<UserDTO> userDTOs) {
        if (userDTOs == null) {
            return null;
        }
        ArrayList<User> list = new ArrayList<User>(userDTOs.size());
        for (UserDTO userDTO : userDTOs) {
            list.add(this.userDTOToUser(userDTO));
        }
        return list;
    }
}

