/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service_ptac;

import java.io.InputStream;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileExistsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.interfaces.VisualizerMessageListener;
import org.powertac.common.interfaces.VisualizerProxy;
import org.powertac.server.CompetitionControlService;
import org.powertac.server.CompetitionSetupService;
import org.powertac.server.LogService;
import org.powertac.visualizer.domain.File;
import org.powertac.visualizer.domain.Game;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.domain.enumeration.FileType;
import org.powertac.visualizer.logtool.LogtoolExecutor;
import org.powertac.visualizer.service.FileService;
import org.powertac.visualizer.service.GameService;
import org.powertac.visualizer.service_ptac.MessageDispatcher;
import org.powertac.visualizer.service_ptac.VisualizerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmbeddedService {
    Logger log = LogManager.getLogger(EmbeddedService.class);
    @Autowired
    private FileService fileService;
    @Autowired
    private GameService gameService;
    @Autowired
    private VisualizerService visualizerService;
    @Autowired
    private MessageDispatcher messageDispatcher;
    @Autowired
    private CompetitionSetupService competitionSetupService;
    @Autowired
    private CompetitionControlService competitionControlService;
    @Autowired
    private LogService logService;
    @Autowired
    private VisualizerProxy visualizerProxy;
    private Thread replayGameThread;
    private LogtoolExecutor logtoolExecutor;
    private Game currentGame;

    @PostConstruct
    private void afterPropertiesSet() {
        this.visualizerProxy.registerVisualizerMessageListener((VisualizerMessageListener)this.messageDispatcher);
        this.logtoolExecutor = new LogtoolExecutor();
    }

    public String runBootGame(Game game, User user) throws FileExistsException {
        String error = this.checkRun();
        if (error != null) {
            return error;
        }
        this.visualizerService.recycleAll();
        this.visualizerService.setState(VisualizerService.VisualizerState.WAITING);
        String fileName = File.getSafeName((String)game.getName()) + ".xml";
        File bootFile = this.fileService.createFile(FileType.BOOT, fileName, user);
        if (bootFile.exists()) {
            throw new FileExistsException();
        }
        game.setBootFile(bootFile);
        System.setProperty("logdir", "files" + File.separator + user.getLogin() + File.separator + "log");
        String id = game.getName();
        String base = File.getSafeName((String)(this.logService.getPrefix() + "-boot-" + id));
        game.setTraceFile(this.fileService.createFile(FileType.TRACE, base + ".trace", user));
        game.setStateFile(this.fileService.createFile(FileType.STATE, base + ".state", user));
        this.currentGame = game;
        error = this.competitionSetupService.bootSession(game.getBootFilePath(), game.getConfigFilePath(), id);
        if (error != null) {
            this.visualizerService.setState(VisualizerService.VisualizerState.FAILED);
        }
        return error;
    }

    public String runSimGame(Game game, User user) {
        String error = this.checkRun();
        if (error != null) {
            return error;
        }
        this.visualizerService.recycleAll();
        this.visualizerService.setState(VisualizerService.VisualizerState.WAITING);
        System.setProperty("logdir", "files" + File.separator + user.getLogin() + File.separator + "log");
        String id = game.getName();
        String base = File.getSafeName((String)(this.logService.getPrefix() + "-sim-" + id));
        game.setTraceFile(this.fileService.createFile(FileType.TRACE, base + ".trace", user));
        game.setStateFile(this.fileService.createFile(FileType.STATE, base + ".state", user));
        this.currentGame = game;
        error = this.competitionSetupService.simSession(game.getBootFilePath(), game.getConfigFilePath(), null, id, game.getBrokerList(), game.getSeedFilePath(), game.getWeatherFilePath(), null);
        if (error != null) {
            this.visualizerService.setState(VisualizerService.VisualizerState.FAILED);
        }
        return error;
    }

    public String runReplayGame(InputStream source) {
        String error = this.checkRun();
        if (error != null) {
            return error;
        }
        this.visualizerService.recycleAll();
        this.replayGameThread = new /* Unavailable Anonymous Inner Class!! */;
        this.replayGameThread.start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeGame() {
        if (this.currentGame != null) {
            if (this.competitionControlService.isRunning()) {
                this.competitionControlService.shutDown();
            }
            this.gameService.delete(this.currentGame);
            this.currentGame = null;
        }
        if (this.replayGameThread != null) {
            Thread thread = this.replayGameThread;
            synchronized (thread) {
                try {
                    this.logtoolExecutor.interrupt();
                    this.replayGameThread.interrupt();
                    this.replayGameThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.replayGameThread = null;
            }
        }
        this.visualizerService.setState(VisualizerService.VisualizerState.FINISHED);
    }

    private String checkRun() {
        if (this.visualizerService.getMode().equals("tournament")) {
            return "Can't run game in Tournament mode";
        }
        if (this.competitionControlService != null && this.competitionControlService.isRunning() || this.replayGameThread != null) {
            return "Can't run game, already running";
        }
        return null;
    }
}

