/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service_ptac;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.powertac.visualizer.domain.Game;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.domain.enumeration.FileType;
import org.powertac.visualizer.service.FileService;
import org.powertac.visualizer.service.GameService;
import org.powertac.visualizer.service.UserService;
import org.powertac.visualizer.service_ptac.VisualizerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncFilesService {
    private static Logger log = LoggerFactory.getLogger(SyncFilesService.class);
    @Autowired
    private VisualizerService visualizerService;
    @Autowired
    private UserService userService;
    @Autowired
    private FileService fileService;
    @Autowired
    private GameService gameService;

    @Scheduled(fixedDelay=30000L, initialDelay=60000L)
    @Transactional
    public void syncFileSystem() {
        if (this.visualizerService.getState().equals((Object)VisualizerService.VisualizerState.RUNNING) || this.visualizerService.getState().equals((Object)VisualizerService.VisualizerState.WAITING)) {
            log.debug("Skipping sync, game in progress");
            return;
        }
        long t = System.currentTimeMillis();
        log.debug("Starting at " + new Date());
        this.sync(FileType.TRACE, "log", new String[]{".trace"});
        this.sync(FileType.STATE, "log", new String[]{".state"});
        this.sync(FileType.BOOT, "boot", new String[]{".xml"});
        this.sync(FileType.SEED, "seed", new String[]{".state"});
        this.sync(FileType.CONFIG, "config", new String[]{".properties", ".props"});
        this.sync(FileType.WEATHER, "weather", new String[]{".xml"});
        t = System.currentTimeMillis() - t;
        log.debug("Finished after " + t + " milliseconds");
    }

    private boolean sync(FileType type, String typedir, String[] suffixes) {
        int additions = 0;
        int deletions = 0;
        File root = new File("files");
        log.trace("Syncing type " + type + "...");
        for (File userdir : root.listFiles()) {
            File found;
            Object expected2;
            String login;
            User user;
            if (!userdir.isDirectory() || (user = (User)this.userService.getUserByLogin(login = userdir.getName()).orElse(null)) == null) continue;
            log.trace("Syncing user " + login + "...");
            List expectedList = this.fileService.findByOwnerIsCurrentUser(login, type).stream().sorted(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
            userdir = new File(userdir, typedir);
            if (!userdir.exists() || !userdir.isDirectory()) {
                for (Object expected2 : expectedList) {
                    log.debug("Going to delete file " + expected2.getName());
                    for (Game game : this.gameService.findByAssociatedFile((org.powertac.visualizer.domain.File)expected2)) {
                        log.debug("  ... also have to clear refs in Game " + game.getName());
                        this.clearFileRefsFromGame(game, expected2.getId());
                    }
                    this.fileService.delete((org.powertac.visualizer.domain.File)expected2);
                }
                continue;
            }
            log.trace("Entering " + userdir.getAbsolutePath());
            LinkedList<File> foundList = new LinkedList<File>();
            for (File log : userdir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */)) {
                if (!log.isFile()) continue;
                foundList.add(log);
            }
            foundList.sort((Comparator<File>)new /* Unavailable Anonymous Inner Class!! */);
            log.trace("Expected for user " + login + ":");
            for (org.powertac.visualizer.domain.File file : expectedList) {
                log.trace("    " + file.getName());
            }
            log.trace("Found for user " + login + ":");
            expected2 = foundList.iterator();
            while (expected2.hasNext()) {
                File file = (File)expected2.next();
                log.trace("    " + file.getName());
            }
            Iterator expectedIt = expectedList.iterator();
            Iterator foundIt = foundList.iterator();
            org.powertac.visualizer.domain.File expected3 = expectedIt.hasNext() ? (org.powertac.visualizer.domain.File)expectedIt.next() : null;
            File file = found = foundIt.hasNext() ? (File)foundIt.next() : null;
            while (expected3 != null || found != null) {
                if (expected3 == null) {
                    log.debug("Creating for user " + login + ": " + found.getName());
                    this.fileService.createFile(type, found.getName(), user);
                    found = foundIt.hasNext() ? (File)foundIt.next() : null;
                    ++additions;
                    continue;
                }
                if (found == null) {
                    log.debug("Deleting for user " + login + ": " + expected3.getName());
                    for (Game game : this.gameService.findByAssociatedFile(expected3)) {
                        log.debug("  ... also have to clear refs in Game " + game.getName());
                        this.clearFileRefsFromGame(game, expected3.getId());
                    }
                    this.fileService.delete(expected3);
                    expected3 = expectedIt.hasNext() ? (org.powertac.visualizer.domain.File)expectedIt.next() : null;
                    ++deletions;
                    continue;
                }
                int cmp = expected3.getName().compareTo(found.getName());
                if (cmp > 0) {
                    log.debug("Creating for user " + login + ": " + found.getName());
                    this.fileService.createFile(type, found.getName(), user);
                    found = foundIt.hasNext() ? (File)foundIt.next() : null;
                    ++additions;
                    continue;
                }
                if (cmp < 0) {
                    log.debug("Deleting for user " + login + ": " + expected3.getName());
                    for (Game game : this.gameService.findByAssociatedFile(expected3)) {
                        log.debug("  ... also have to clear refs in Game " + game.getName());
                        this.clearFileRefsFromGame(game, expected3.getId());
                    }
                    this.fileService.delete(expected3);
                    expected3 = expectedIt.hasNext() ? (org.powertac.visualizer.domain.File)expectedIt.next() : null;
                    ++deletions;
                    continue;
                }
                found = foundIt.hasNext() ? (File)foundIt.next() : null;
                expected3 = expectedIt.hasNext() ? (org.powertac.visualizer.domain.File)expectedIt.next() : null;
            }
        }
        log.trace(additions + " additions, " + deletions + " deletions");
        return additions != 0 || deletions != 0;
    }

    private void clearFileRefsFromGame(Game game, Long fileId) {
        boolean changed = false;
        if (game.getTraceFileId() == fileId) {
            game.setTraceFile(null);
            changed = true;
        }
        if (game.getStateFileId() == fileId) {
            game.setStateFile(null);
            changed = true;
        }
        if (game.getSeedFileId() == fileId) {
            game.setSeedFile(null);
            changed = true;
        }
        if (game.getConfigFileId() == fileId) {
            game.setConfigFile(null);
            changed = true;
        }
        if (game.getWeatherFileId() == fileId) {
            game.setWeatherFile(null);
            changed = true;
        }
        if (game.getBootFileId() == fileId) {
            game.setBootFile(null);
            changed = true;
        }
        if (changed) {
            this.gameService.save(game);
        }
    }
}

