/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.examples.promise;

import java.util.List;
import org.pragmatica.lang.Promise;
import org.pragmatica.lang.Result;
import org.pragmatica.lang.utils.Causes;

class AsynchronousUserFetchingExample {
    private final UserRepository userRepository = List::of;

    AsynchronousUserFetchingExample() {
    }

    Promise<List<User>> fetchUsers1() {
        return Promise.promise(promise -> promise.resolve(Result.lift(Causes::fromThrowable, this.userRepository::findAll)));
    }

    Promise<List<User>> fetchUsers2() {
        return Promise.promise(() -> Result.lift(Causes::fromThrowable, this.userRepository::findAll));
    }

    Promise<List<User>> fetchUsers3() {
        return Promise.lift(Causes::fromThrowable, this.userRepository::findAll);
    }

    Promise<List<User>> fetchUsers4() {
        Promise promise = Promise.promise();
        promise.async(p -> p.resolve(Result.lift(Causes::fromThrowable, this.userRepository::findAll)));
        return promise;
    }

    static interface UserRepository {
        public List<User> findAll();
    }

    record User(String id, String name) {
        boolean isActive() {
            return true;
        }
    }
}

