/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.examples.promise;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.pragmatica.lang.Cause;
import org.pragmatica.lang.Option;
import org.pragmatica.lang.Promise;
import org.pragmatica.lang.Result;
import org.pragmatica.lang.io.CoreError;

public class ComprehensivePromiseExamples {
    public void basicPromiseOperations() {
        Promise resolved = Promise.resolved((Result)Result.success((Object)"Hello, World!"));
        Promise failed = Promise.failure((Cause)CoreError.exception((Throwable)new RuntimeException("Error occurred")));
        Promise computed = Promise.promise(() -> {
            try {
                Thread.sleep(100L);
                return Result.success((Object)42);
            }
            catch (Exception e) {
                return Result.failure((Cause)CoreError.exception((Throwable)e));
            }
        });
        Promise transformed = computed.map(value -> "Result: " + value);
        Promise chained = transformed.flatMap(str -> Promise.promise(() -> Result.success((Object)str.toUpperCase())));
    }

    public void errorHandlingPatterns() {
        Promise riskyOperation = Promise.promise(() -> {
            if (Math.random() > 0.5) {
                return Result.failure((Cause)CoreError.exception((Throwable)new RuntimeException("Random failure")));
            }
            return Result.success((Object)"Success!");
        });
        Promise withRecovery = riskyOperation.recover(error -> "Recovered from: " + error.message());
        Promise withErrorTransform = riskyOperation.mapError(error -> CoreError.exception((Throwable)new IllegalStateException("Wrapped: " + error.message())));
        Promise withFallback = riskyOperation.orElse(() -> Promise.resolved((Result)Result.success((Object)"Default value")));
    }

    public void compositionPatterns() {
        List<Promise> promises = List.of(Promise.promise(() -> {
            try {
                Thread.sleep(100L);
                return Result.success((Object)"First");
            }
            catch (Exception e) {
                return Result.failure((Cause)CoreError.exception((Throwable)e));
            }
        }), Promise.promise(() -> {
            try {
                Thread.sleep(200L);
                return Result.success((Object)"Second");
            }
            catch (Exception e) {
                return Result.failure((Cause)CoreError.exception((Throwable)e));
            }
        }), Promise.promise(() -> {
            try {
                Thread.sleep(150L);
                return Result.success((Object)"Third");
            }
            catch (Exception e) {
                return Result.failure((Cause)CoreError.exception((Throwable)e));
            }
        }));
        Promise allResults = Promise.allOf(promises);
        Promise firstResult = Promise.any(promises);
        Promise sequential = Promise.resolved((Result)Result.success((Object)"Start")).flatMap(start -> Promise.promise(() -> Result.success((Object)(start + " -> Step 1")))).flatMap(step1 -> Promise.promise(() -> Result.success((Object)(step1 + " -> Step 2")))).flatMap(step2 -> Promise.promise(() -> Result.success((Object)(step2 + " -> Complete"))));
    }

    public void monadIntegration() {
        Promise resultPromise = Promise.promise(() -> {
            try {
                return Result.success((Object)Result.success((Object)"Operation completed"));
            }
            catch (Exception e) {
                return Result.success((Object)Result.failure((Cause)CoreError.exception((Throwable)e)));
            }
        });
        Promise optionPromise = Promise.promise(() -> {
            String value = this.findValueSomewhere();
            return Result.success((Object)Option.option((Object)value));
        });
        Promise flattened = resultPromise.flatMap(result -> (Promise)result.fold(error -> Promise.failure((Cause)error), success -> Promise.resolved((Result)Result.success((Object)success))));
    }

    public void asyncIOOperations() {
        Promise fileContent = Promise.promise(() -> {
            try {
                Thread.sleep(500L);
                return Result.success((Object)"File content...");
            }
            catch (Exception e) {
                return Result.failure((Cause)CoreError.exception((Throwable)e));
            }
        });
        Promise processedLines = fileContent.map(content -> List.of(content.split("\n"))).map(lines -> lines.stream().map(String::trim).filter(line -> !line.isEmpty()).toList());
    }

    public void parallelProcessing() {
        List<Integer> data = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10));
        List<Promise> parallelWork = data.stream().map(item -> Promise.promise(() -> {
            try {
                Thread.sleep(100L);
                return Result.success((Object)(item * item));
            }
            catch (Exception e) {
                return Result.failure((Cause)CoreError.exception((Throwable)e));
            }
        })).toList();
        Promise allResults = Promise.allOf(parallelWork);
        Promise sum = allResults.map(results -> results.stream().mapToInt(result -> (Integer)result.or((Object)0)).sum());
    }

    public void timeoutAndCancellation() {
        Promise longRunningTask = Promise.promise(() -> {
            try {
                Thread.sleep(5000L);
                return Result.success((Object)"Task completed");
            }
            catch (Exception e) {
                return Result.failure((Cause)CoreError.exception((Throwable)e));
            }
        });
        Promise withTimeout = longRunningTask.recover(error -> "Task timed out");
    }

    public void migrationFromCompletableFuture() {
        CompletionStage oldWay = ((CompletableFuture)CompletableFuture.supplyAsync(() -> "Hello").thenApply(s -> s + " World")).exceptionally(throwable -> "Error: " + throwable.getMessage());
        Promise newWay = Promise.promise(() -> Result.success((Object)"Hello")).map(s -> s + " World").recover(error -> "Error: " + error.message());
    }

    private String findValueSomewhere() {
        return Math.random() > 0.5 ? "Found value" : null;
    }
}

