/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.examples.promise;

import java.util.List;
import org.pragmatica.lang.Cause;
import org.pragmatica.lang.Promise;
import org.pragmatica.lang.utils.Causes;

class PromiseAnyOperationExample {
    private final WeatherService openWeatherMapService = string -> Causes.cause((String)"Not implemented").promise();
    private final WeatherService weatherstackService = string -> Causes.cause((String)"Not implemented").promise();
    private final WeatherService accuWeatherService = string -> Causes.cause((String)"Not implemented").promise();
    private final WeatherService NWService = string -> Causes.cause((String)"Not implemented").promise();
    private final UserRepository userRepository = userId -> Causes.cause((String)"User not found").promise();
    private final OrderRepository orderRepository = user -> Causes.cause((String)"Order not found").promise();
    private final InvoiceService invoiceService = list -> Causes.cause((String)"Invoice generation failed").promise();
    private final EmailService emailService = invoice -> {};
    private final LogService logService = (string, cause) -> {};

    PromiseAnyOperationExample() {
    }

    Promise<WeatherInfo> fetchWeatherInfo(String city) {
        return Promise.any((Promise[])new Promise[]{this.openWeatherMapService.fetchWeatherInfo(city), this.weatherstackService.fetchWeatherInfo(city), this.accuWeatherService.fetchWeatherInfo(city), this.NWService.fetchWeatherInfo(city)});
    }

    Promise<Invoice> processUserOrders(UserId userId) {
        return this.userRepository.findUserById(userId).flatMap(this.orderRepository::findOrdersByUser).flatMap(this.invoiceService::createInvoice).onSuccess(this.emailService::sendInvoice).onFailure(cause -> this.logService.logError("Invoice generation failed", (Cause)cause));
    }

    static interface WeatherService {
        public Promise<WeatherInfo> fetchWeatherInfo(String var1);
    }

    static interface UserRepository {
        public Promise<User> findUserById(UserId var1);
    }

    static interface OrderRepository {
        public Promise<List<Order>> findOrdersByUser(User var1);
    }

    static interface InvoiceService {
        public Promise<Invoice> createInvoice(List<Order> var1);
    }

    static interface EmailService {
        public void sendInvoice(Invoice var1);
    }

    static interface LogService {
        public void logError(String var1, Cause var2);
    }

    record UserId(String id) {
    }

    record Invoice(List<Order> orders) {
    }

    record Order(UserId userId, String description) {
    }

    record User(UserId id, String name) {
    }

    record WeatherInfo(String city, String temperature) {
    }
}

