/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.examples.promise;

import java.util.List;
import org.pragmatica.lang.Promise;
import org.pragmatica.lang.Result;
import org.pragmatica.lang.io.TimeSpan;

class AsynchronousUserDataProcessingExample {
    AsynchronousUserDataProcessingExample() {
    }

    void retrieveAndPrintUserSummaries() {
        List<String> userIds = List.of("user1", "user2", "user3", "user4", "user5");
        List<Promise> promises = userIds.stream().map(this::processUserAsync).toList();
        Promise.allOf(promises).flatMap(users -> Result.allOf((List)users).async()).onSuccess(users -> users.forEach(this::displayUserSummary)).onFailure(System.err::println);
    }

    Promise<UserData> processUserAsync(String userId) {
        return Promise.promise((TimeSpan)TimeSpan.timeSpan((long)100L).millis(), promise -> promise.succeed((Object)new UserData(userId, "User " + userId, "user" + userId + "@example.com")));
    }

    void displayUserSummary(UserData userData) {
        System.out.println("User ID: " + userData.userId());
        System.out.println("Name: " + userData.name());
        System.out.println("Email: " + userData.email());
    }

    record UserData(String userId, String name, String email) {
    }
}

