/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.examples.promise;

import java.util.List;
import java.util.UUID;
import org.pragmatica.lang.Promise;
import org.pragmatica.lang.utils.Causes;

class ForkJoinPromiseUserProfileFetcher {
    private final UserService userService = userId -> Causes.cause((String)"Not implemented").promise();
    private final PostService postService = userId -> Causes.cause((String)"Not implemented").promise();
    private final FriendService friendService = userId -> Causes.cause((String)"Not implemented").promise();

    ForkJoinPromiseUserProfileFetcher() {
    }

    Promise<UserProfile> fetchUserProfile(UserId userId) {
        return Promise.all(this.userService.fetchUserData(userId), this.postService.fetchUserPosts(userId), this.friendService.fetchUserFriends(userId)).map(UserProfile::new);
    }

    static interface UserService {
        public Promise<UserData> fetchUserData(UserId var1);
    }

    static interface PostService {
        public Promise<List<Post>> fetchUserPosts(UserId var1);
    }

    static interface FriendService {
        public Promise<List<Friend>> fetchUserFriends(UserId var1);
    }

    record UserId(UUID id) {
    }

    record UserProfile(UserData userData, List<Post> posts, List<Friend> friends) {
    }

    record Friend(UserId friendId, String name) {
    }

    record Post(PostId postId, String content) {
    }

    record UserData(UserId userId, String name, String email) {
    }

    record PostId(UUID id) {
    }
}

