/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.examples.promise;

import java.math.BigDecimal;
import java.util.Currency;
import java.util.List;
import org.pragmatica.lang.Cause;
import org.pragmatica.lang.Promise;
import org.pragmatica.lang.io.TimeSpan;
import org.pragmatica.lang.utils.Causes;
import org.pragmatica.lang.utils.Retry;

class SequentialPromiseOperationExample {
    private final UserRepository userRepository = userId -> Causes.cause((String)"User not found").promise();
    private final OrderRepository orderRepository = user -> Causes.cause((String)"Order not found").promise();
    private final InvoiceService invoiceService = list -> Causes.cause((String)"Invoice generation failed").promise();
    private final EmailService emailService = invoice -> {};
    private final LogService logService = (string, cause) -> {};
    private final PaymentService paymentService = payment -> Causes.cause((String)"Payment failed").promise();
    private Retry retry = Retry.create().attempts(5).strategy(Retry.BackoffStrategy.fixed().interval(TimeSpan.timeSpan((long)2L).seconds()));

    SequentialPromiseOperationExample() {
    }

    Promise<Invoice> processUserOrders(UserId userId) {
        return this.userRepository.findUserById(userId).flatMap(this.orderRepository::findOrdersByUser).flatMap(this.invoiceService::createInvoice).onSuccess(this.emailService::sendInvoice).onFailure(cause -> this.logService.logError("Invoice generation failed", (Cause)cause));
    }

    Promise<PaymentConfirmation> processPayment(Payment payment) {
        return this.retry.execute(() -> this.paymentService.processPayment(payment));
    }

    void configureRetry() {
        Retry linear = Retry.create().attempts(5).strategy(Retry.BackoffStrategy.linear().initialDelay(TimeSpan.timeSpan((long)50L).millis()).increment(TimeSpan.timeSpan((long)50L).millis()).maxDelay(TimeSpan.timeSpan((long)1L).seconds()));
    }

    static interface UserRepository {
        public Promise<User> findUserById(UserId var1);
    }

    static interface OrderRepository {
        public Promise<List<Order>> findOrdersByUser(User var1);
    }

    static interface InvoiceService {
        public Promise<Invoice> createInvoice(List<Order> var1);
    }

    static interface EmailService {
        public void sendInvoice(Invoice var1);
    }

    static interface LogService {
        public void logError(String var1, Cause var2);
    }

    static interface PaymentService {
        public Promise<PaymentConfirmation> processPayment(Payment var1);
    }

    record UserId(String id) {
    }

    record Payment(UserId userId, Amount amount, Currency currency) {
    }

    record PaymentConfirmation(String message) {
    }

    record Amount(BigDecimal value) {
    }

    record Invoice(List<Order> orders) {
    }

    record Order(UserId userId, String description) {
    }

    record User(UserId id, String name) {
    }
}

