/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.audio.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.stream.Stream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.praxislive.core.Settings;
import org.praxislive.ide.audio.options.GeneralAudioOptionsPanelController;

final class GeneralAudioPanel
extends JPanel {
    private static final String KEY_LIBRARY = "audio.library";
    private static final String KEY_DEVICE = "audio.device";
    private static final String KEY_BUFFERSIZE = "audio.buffersize";
    private static final String KEY_INPUT_DEVICE = "audio.input-device";
    private static final String JAVASOUND = "JavaSound";
    private static final String JACK = "JACK";
    private static final DeviceInfo DEFAULT_DEVICE_INFO = new DeviceInfo(null, 32, 32);
    private static final List<Library> LIBRARIES = List.of(new Library("JavaSound", "JavaSound"), new Library("JACK", "Jack Audio Connection Kit"));
    private static final List<Integer> BUFFERSIZES = List.of(Integer.valueOf(32), Integer.valueOf(64), Integer.valueOf(128), Integer.valueOf(256), Integer.valueOf(512), Integer.valueOf(1024), Integer.valueOf(2048), Integer.valueOf(4096));
    private final GeneralAudioOptionsPanelController controller;
    private JComboBox buffersizeChooser;
    private JLabel buffersizeLbl;
    private JLabel defaultConfigDescription;
    private JPanel defaultConfigPanel;
    private JComboBox deviceChooser;
    private JLabel deviceLbl;
    private JComboBox inputDeviceChooser;
    private JLabel inputDeviceLbl;
    private JComboBox libraryChooser;
    private JLabel libraryLbl;

    GeneralAudioPanel(GeneralAudioOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.initChoosers();
    }

    private void initComponents() {
        this.defaultConfigPanel = new JPanel();
        this.defaultConfigDescription = new JLabel();
        this.libraryLbl = new JLabel();
        this.libraryChooser = new JComboBox();
        this.deviceLbl = new JLabel();
        this.deviceChooser = new JComboBox();
        this.buffersizeLbl = new JLabel();
        this.buffersizeChooser = new JComboBox();
        this.inputDeviceLbl = new JLabel();
        this.inputDeviceChooser = new JComboBox();
        this.defaultConfigPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(GeneralAudioPanel.class, (String)"GeneralAudioPanel.defaultConfigPanel.border.title")));
        this.defaultConfigDescription.setForeground(UIManager.getDefaults().getColor("textInactiveText"));
        this.defaultConfigDescription.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.defaultConfigDescription, (String)NbBundle.getMessage(GeneralAudioPanel.class, (String)"GeneralAudioPanel.defaultConfigDescription.text"));
        Mnemonics.setLocalizedText((JLabel)this.libraryLbl, (String)NbBundle.getMessage(GeneralAudioPanel.class, (String)"GeneralAudioPanel.libraryLbl.text"));
        this.libraryChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralAudioPanel.this.libraryChooserActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.deviceLbl, (String)NbBundle.getMessage(GeneralAudioPanel.class, (String)"GeneralAudioPanel.deviceLbl.text"));
        this.deviceChooser.setEnabled(false);
        this.deviceChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralAudioPanel.this.deviceChooserActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.buffersizeLbl, (String)NbBundle.getMessage(GeneralAudioPanel.class, (String)"GeneralAudioPanel.buffersizeLbl.text"));
        this.buffersizeChooser.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.inputDeviceLbl, (String)NbBundle.getMessage(GeneralAudioPanel.class, (String)"GeneralAudioPanel.inputDeviceLbl.text"));
        this.inputDeviceChooser.setEnabled(false);
        GroupLayout defaultConfigPanelLayout = new GroupLayout(this.defaultConfigPanel);
        this.defaultConfigPanel.setLayout(defaultConfigPanelLayout);
        defaultConfigPanelLayout.setHorizontalGroup(defaultConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(defaultConfigPanelLayout.createSequentialGroup().addGroup(defaultConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(defaultConfigPanelLayout.createSequentialGroup().addGap(42, 42, 42).addComponent(this.defaultConfigDescription, -1, -1, Short.MAX_VALUE)).addGroup(defaultConfigPanelLayout.createSequentialGroup().addContainerGap().addGroup(defaultConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.buffersizeLbl).addComponent(this.libraryLbl).addComponent(this.deviceLbl).addComponent(this.inputDeviceLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(defaultConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputDeviceChooser, 0, -1, Short.MAX_VALUE).addComponent(this.buffersizeChooser, 0, -1, Short.MAX_VALUE).addComponent(this.libraryChooser, 0, -1, Short.MAX_VALUE).addComponent(this.deviceChooser, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        defaultConfigPanelLayout.setVerticalGroup(defaultConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(defaultConfigPanelLayout.createSequentialGroup().addContainerGap().addGroup(defaultConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.libraryChooser, -2, -1, -2).addComponent(this.libraryLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(defaultConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deviceChooser, -2, -1, -2).addComponent(this.deviceLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(defaultConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputDeviceChooser, -2, -1, -2).addComponent(this.inputDeviceLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(defaultConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buffersizeLbl).addComponent(this.buffersizeChooser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 205, Short.MAX_VALUE).addComponent(this.defaultConfigDescription).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.defaultConfigPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.defaultConfigPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void libraryChooserActionPerformed(ActionEvent evt) {
        Object o = this.libraryChooser.getSelectedItem();
        if (o instanceof Library) {
            this.initLibrary((Library)o);
        }
    }

    private void deviceChooserActionPerformed(ActionEvent evt) {
        Object o = this.deviceChooser.getSelectedItem();
        if (o instanceof DeviceInfo) {
            DeviceInfo info = (DeviceInfo)o;
            if (info.name() != null && info.inputs() > 0) {
                this.inputDeviceChooser.setSelectedItem(DEFAULT_DEVICE_INFO);
                this.inputDeviceChooser.setEnabled(false);
            } else {
                this.inputDeviceChooser.setEnabled(this.inputDeviceChooser.getItemCount() > 1);
            }
        }
    }

    private void initChoosers() {
        LIBRARIES.forEach(this.libraryChooser::addItem);
        BUFFERSIZES.forEach(this.buffersizeChooser::addItem);
    }

    void load() {
        String libName = Settings.get((String)KEY_LIBRARY, (String)JAVASOUND);
        Library active = LIBRARIES.stream().filter(l -> l.name().equals(libName)).findFirst().orElse(LIBRARIES.getFirst());
        this.libraryChooser.setSelectedItem(active);
    }

    void store() {
        DeviceInfo info;
        Object o = this.libraryChooser.getSelectedItem();
        if (o instanceof Library) {
            Library library = (Library)o;
            Settings.put((String)KEY_LIBRARY, (String)library.name());
        }
        if ((o = this.deviceChooser.getSelectedItem()) instanceof DeviceInfo) {
            info = (DeviceInfo)o;
            Settings.put((String)KEY_DEVICE, (String)info.name());
        }
        if ((o = this.inputDeviceChooser.getSelectedItem()) instanceof DeviceInfo) {
            info = (DeviceInfo)o;
            Settings.put((String)KEY_INPUT_DEVICE, (String)info.name());
        }
        if (this.buffersizeChooser.isEnabled() && (o = this.buffersizeChooser.getSelectedItem()) instanceof Integer) {
            Integer buffersize = (Integer)o;
            Settings.putInt((String)KEY_BUFFERSIZE, (int)buffersize);
        }
    }

    private void initLibrary(Library lib) {
        this.deviceChooser.removeAllItems();
        this.inputDeviceChooser.removeAllItems();
        this.deviceChooser.addItem(DEFAULT_DEVICE_INFO);
        this.deviceChooser.setSelectedItem(DEFAULT_DEVICE_INFO);
        this.inputDeviceChooser.addItem(DEFAULT_DEVICE_INFO);
        this.inputDeviceChooser.setSelectedItem(DEFAULT_DEVICE_INFO);
        if (JAVASOUND.equals(lib.name())) {
            String devName = Settings.get((String)KEY_DEVICE, (String)"");
            String inDevName = Settings.get((String)KEY_INPUT_DEVICE, (String)"");
            for (DeviceInfo info : this.findJavaSoundDevices()) {
                if (info.outputs > 0) {
                    this.deviceChooser.addItem(info);
                    if (!devName.equals(info.name())) continue;
                    this.deviceChooser.setSelectedItem(info);
                    continue;
                }
                if (info.inputs <= 0) continue;
                this.inputDeviceChooser.addItem(info);
                if (!inDevName.equals(info.name())) continue;
                this.inputDeviceChooser.setSelectedItem(info);
            }
            this.deviceChooser.setEnabled(true);
            this.inputDeviceChooser.setEnabled(this.inputDeviceChooser.getItemCount() > 1);
            int bsize = Settings.getInt((String)KEY_BUFFERSIZE, (int)2048);
            this.buffersizeChooser.setSelectedItem(bsize);
            this.buffersizeChooser.setEnabled(true);
        } else {
            this.deviceChooser.setEnabled(false);
            this.inputDeviceChooser.setEnabled(false);
            this.buffersizeChooser.setSelectedItem(2048);
            this.buffersizeChooser.setEnabled(false);
        }
    }

    private List<DeviceInfo> findJavaSoundDevices() {
        return Stream.of(AudioSystem.getMixerInfo()).map(AudioSystem::getMixer).map(mixer -> new DeviceInfo(mixer.getMixerInfo().getName(), this.maxChannels((Mixer)mixer, true), this.maxChannels((Mixer)mixer, false))).toList();
    }

    private int maxChannels(Mixer mixer, boolean input) {
        Line.Info[] lines;
        int max = 0;
        for (Line.Info line : lines = input ? mixer.getTargetLineInfo() : mixer.getSourceLineInfo()) {
            AudioFormat[] formats;
            if (!(line instanceof DataLine.Info)) continue;
            DataLine.Info info = (DataLine.Info)line;
            for (AudioFormat format : formats = info.getFormats()) {
                int channels = format.getChannels();
                if (channels == -1) {
                    max = 32;
                    continue;
                }
                if (channels <= max) continue;
                max = channels;
            }
        }
        return max;
    }

    boolean valid() {
        return true;
    }

    private record Library(String name, String displayName) {
        @Override
        public String toString() {
            return this.displayName();
        }
    }

    private record DeviceInfo(String name, int inputs, int outputs) {
        @Override
        public String toString() {
            return this.name() == null ? "Default Device" : this.name();
        }
    }
}

