/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.code;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.praxislive.ide.code.api.SharedCodeInfo;
import org.praxislive.ide.project.api.PraxisProject;

public class PathRegistry {
    private static final PathRegistry INSTANCE = new PathRegistry();
    private final Map<FileObject, Info> registry = new HashMap<FileObject, Info>();

    private PathRegistry() {
    }

    public void register(PraxisProject project, FileObject root) {
        this.registerImpl(project, root, null);
    }

    public void register(PraxisProject project, FileObject root, SharedCodeInfo shared) {
        this.registerImpl(project, root, shared);
    }

    public void unregister(PraxisProject project, FileObject root) {
        this.unregisterImpl((Project)project, root);
    }

    synchronized Info findInfo(FileObject file) {
        for (FileObject f = file; f != null; f = f.getParent()) {
            Info info = this.registry.get(f);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private synchronized void registerImpl(PraxisProject project, FileObject root, SharedCodeInfo shared) {
        Info sharedInfo;
        ClassPath classpath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{root});
        if (shared != null && (sharedInfo = this.findInfo(shared.getFolder())) != null) {
            classpath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classpath, sharedInfo.classpath});
        }
        GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{classpath});
        Info info = new Info(project, classpath);
        this.registry.put(root, info);
    }

    private synchronized void unregisterImpl(Project project, FileObject root) {
        Info info = this.registry.remove(root);
        if (info != null) {
            GlobalPathRegistry.getDefault().unregister("classpath/source", new ClassPath[]{info.classpath()});
        }
    }

    public static PathRegistry getDefault() {
        return INSTANCE;
    }

    static class Info {
        private final PraxisProject project;
        private final ClassPath classpath;

        public Info(PraxisProject project, ClassPath classpath) {
            this.project = project;
            this.classpath = classpath;
        }

        ClassPath classpath() {
            return this.classpath;
        }

        PraxisProject project() {
            return this.project;
        }
    }
}

