/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.code.api;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ClassBodyWrapper {
    private static final String NEW_LINE = "\n";
    private static final String DEFAULT_CLASS_NAME = "$";
    private static final Filter DEFAULT_FILTER = new DefaultFilter();
    private List<String> defaultImports = List.of();
    private String className = "$";
    private String extendedType;
    private List<String> implementedTypes = List.of();
    private boolean ignoreExtends = false;
    private Filter filter = DEFAULT_FILTER;
    private static final Pattern IMPORT_STATEMENT_PATTERN = Pattern.compile("\\s*import\\s+((?:static\\s+)?\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.\\*)?);");
    private static final Pattern EXTENDS_STATEMENT_PATTERN = Pattern.compile("\\s*extends\\s+(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.\\*)?);");

    private ClassBodyWrapper() {
    }

    public ClassBodyWrapper className(String className) {
        this.className = Objects.requireNonNull(className);
        return this;
    }

    public ClassBodyWrapper defaultImports(List<String> defaultImports) {
        this.defaultImports = List.copyOf(defaultImports);
        return this;
    }

    public ClassBodyWrapper extendsType(String extendedType) {
        this.extendedType = extendedType;
        return this;
    }

    public ClassBodyWrapper implementsTypes(List<String> implementedTypes) {
        this.implementedTypes = List.copyOf(implementedTypes);
        return this;
    }

    public ClassBodyWrapper ignoreExtends(boolean ignore) {
        this.ignoreExtends = ignore;
        return this;
    }

    public ClassBodyWrapper filter(Filter filter) {
        this.filter = filter == null ? DEFAULT_FILTER : filter;
        return this;
    }

    public String wrap(String source) {
        String simpleClassName;
        String packageName;
        Matcher matcher;
        List sourceExtends;
        StringBuilder sb = new StringBuilder();
        Map partitionedSource = source.lines().collect(Collectors.groupingBy(ClassBodyWrapper::categorize, () -> new EnumMap(LineCategory.class), Collectors.toList()));
        String superClass = this.extendedType;
        if (!this.ignoreExtends && !(sourceExtends = partitionedSource.getOrDefault((Object)LineCategory.EXTENDS, List.of())).isEmpty() && (matcher = EXTENDS_STATEMENT_PATTERN.matcher((CharSequence)sourceExtends.get(0))).lookingAt()) {
            superClass = matcher.group(1);
        }
        List<String> sourceImports = partitionedSource.getOrDefault((Object)LineCategory.IMPORT, List.of());
        List<String> sourceBody = partitionedSource.getOrDefault((Object)LineCategory.BODY, List.of());
        int idx = this.className.lastIndexOf(46);
        if (idx == -1) {
            packageName = "";
            simpleClassName = this.className;
        } else {
            packageName = this.className.substring(0, idx);
            simpleClassName = this.className.substring(idx + 1);
        }
        this.filter.writePackage(sb, packageName);
        this.filter.writeDefaultImports(sb, this.defaultImports);
        this.filter.writeSourceImports(sb, sourceImports);
        this.filter.writeClassDeclaration(sb, simpleClassName, superClass, this.implementedTypes);
        this.filter.writeSourceBody(sb, sourceBody);
        this.filter.writeClassEnding(sb);
        return sb.toString();
    }

    public static ClassBodyWrapper create() {
        return new ClassBodyWrapper();
    }

    private static LineCategory categorize(String line) {
        if (IMPORT_STATEMENT_PATTERN.matcher(line).lookingAt()) {
            return LineCategory.IMPORT;
        }
        if (EXTENDS_STATEMENT_PATTERN.matcher(line).lookingAt()) {
            return LineCategory.EXTENDS;
        }
        return LineCategory.BODY;
    }

    public static interface Filter {
        default public void writePackage(StringBuilder sb, String packageName) {
            if (!packageName.isEmpty()) {
                sb.append("package ").append(packageName).append(";").append(ClassBodyWrapper.NEW_LINE);
            }
        }

        default public void writeDefaultImports(StringBuilder sb, List<String> imports) {
            if (!imports.isEmpty()) {
                imports.forEach(i -> sb.append("import ").append((String)i).append(";").append(ClassBodyWrapper.NEW_LINE));
            }
        }

        default public void writeSourceImports(StringBuilder sb, List<String> imports) {
            imports.forEach(line -> sb.append((String)line).append(ClassBodyWrapper.NEW_LINE));
        }

        default public void writeClassDeclaration(StringBuilder sb, String className, String extendedType, List<String> implementedTypes) {
            sb.append("public class ").append(className);
            if (extendedType != null) {
                sb.append(" extends ").append(extendedType);
            }
            if (!implementedTypes.isEmpty()) {
                sb.append(" implements ");
                sb.append(implementedTypes.stream().collect(Collectors.joining(", ")));
            }
            sb.append(" {").append(ClassBodyWrapper.NEW_LINE);
        }

        default public void writeSourceBody(StringBuilder sb, List<String> body) {
            body.forEach(line -> sb.append((String)line).append(ClassBodyWrapper.NEW_LINE));
        }

        default public void writeClassEnding(StringBuilder sb) {
            sb.append("}").append(ClassBodyWrapper.NEW_LINE);
        }
    }

    private static enum LineCategory {
        BODY,
        IMPORT,
        EXTENDS;

    }

    private static class DefaultFilter
    implements Filter {
        private DefaultFilter() {
        }
    }
}

