/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.code.api;

import java.util.Objects;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.praxislive.ide.code.PathRegistry;
import org.praxislive.ide.code.api.SharedCodeInfo;
import org.praxislive.ide.project.api.PraxisProject;

public final class DynamicPaths {
    private static final DynamicPaths INSTANCE = new DynamicPaths();

    private DynamicPaths() {
    }

    public SharedKey registerShared(PraxisProject project, FileObject root, FileObject sharedFolder) {
        Objects.requireNonNull(project);
        Objects.requireNonNull(root);
        Objects.requireNonNull(sharedFolder);
        if (root != sharedFolder && !FileUtil.isParentOf((FileObject)root, (FileObject)sharedFolder)) {
            throw new IllegalArgumentException("Shared folder must be under root folder");
        }
        PathRegistry.getDefault().register(project, root);
        return new SharedKey(project, root, sharedFolder);
    }

    public Key register(PraxisProject project, FileObject root) {
        return this.register(project, root, null);
    }

    public Key register(PraxisProject project, FileObject root, SharedCodeInfo shared) {
        PathRegistry.getDefault().register(project, root, shared);
        return new Key(project, root);
    }

    public static DynamicPaths getDefault() {
        return INSTANCE;
    }

    public static class SharedKey
    extends Key {
        private final SharedCodeInfo info;

        private SharedKey(PraxisProject project, FileObject root, FileObject sharedFolder) {
            super(project, root);
            this.info = new SharedCodeInfo(root, sharedFolder);
        }

        public SharedCodeInfo info() {
            return this.info;
        }
    }

    public static class Key {
        private final PraxisProject project;
        private final FileObject root;

        private Key(PraxisProject project, FileObject root) {
            this.project = project;
            this.root = root;
        }

        public void unregister() {
            PathRegistry.getDefault().unregister(this.project, this.root);
        }
    }
}

