/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.embedder;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;

public final class CORE {
    private CORE() {
    }

    public static Path launcherFile() throws IOException {
        return CORE.locator().findLauncher();
    }

    public static Path modulesDir() throws IOException {
        return CORE.locator().findModulesDir();
    }

    public static Path installDir() throws IOException {
        return CORE.locator().findInstallDir();
    }

    private static Locator locator() {
        Locator locator = (Locator)Lookup.getDefault().lookup(Locator.class);
        return locator == null ? DefaultLocator.INSTANCE : locator;
    }

    public static interface Locator {
        public Path findLauncher() throws IOException;

        public Path findModulesDir() throws IOException;

        public Path findInstallDir() throws IOException;
    }

    private static final class DefaultLocator
    implements Locator {
        private static final DefaultLocator INSTANCE = new DefaultLocator();

        private DefaultLocator() {
        }

        @Override
        public Path findLauncher() throws IOException {
            Path installDir = this.findInstallDir();
            Path binDir = installDir.resolve("bin");
            Path launcher = BaseUtilities.isWindows() ? binDir.resolve("praxis.cmd") : binDir.resolve("praxis");
            if (Files.exists(launcher, new LinkOption[0])) {
                return launcher;
            }
            throw new IOException("No CORE launcher found");
        }

        @Override
        public Path findModulesDir() throws IOException {
            Path installDir = this.findInstallDir();
            Path modulesDir = installDir.resolve("mods");
            if (Files.isDirectory(modulesDir, new LinkOption[0])) {
                return modulesDir;
            }
            throw new IOException("No CORE modules directory found");
        }

        @Override
        public Path findInstallDir() throws IOException {
            try {
                File modDir = InstalledFileLocator.getDefault().locate("modules", "org.praxislive.ide.core.embedder", false);
                Path installDir = modDir.toPath().getParent().getParent();
                Path coreDir = installDir.resolve("praxiscore");
                if (Files.isDirectory(coreDir, new LinkOption[0])) {
                    return coreDir;
                }
            }
            catch (Exception ex) {
                throw new IOException("No embedded praxiscore directory found", ex);
            }
            throw new IOException("No embedded praxiscore directory found");
        }
    }
}

