package org.praxislive.ide.core.ui;
/** Localizable strings for {@link org.praxislive.ide.core.ui}. */
class Bundle {
    /**
     * @return <i>General</i>
     * @see GeneralOptionsPanelController
     */
    static String AdvancedOption_DisplayName_General() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "AdvancedOption_DisplayName_General");
    }
    /**
     * @return <i>Start, Updates</i>
     * @see GeneralOptionsPanelController
     */
    static String AdvancedOption_Keywords_General() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "AdvancedOption_Keywords_General");
    }
    /**
     * @return <i>Online Help</i>
     * @see OnlineHelpAction
     */
    static String CTL_OnlineHelpAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "CTL_OnlineHelpAction");
    }
    /**
     * @return <i>Report Issue</i>
     * @see ReportIssueAction
     */
    static String CTL_ReportIssueAction() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "CTL_ReportIssueAction");
    }
    /**
     * @return <i>Community Help</i>
     * @see HelpWidget
     */
    static String LBL_CommunityLink() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_CommunityLink");
    }
    /**
     * @return <i>Online documentation</i>
     * @see HelpWidget
     */
    static String LBL_DocsLink() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_DocsLink");
    }
    /**
     * @return <i>Download update</i>
     * @see IDEInfoWidget
     */
    static String LBL_Download() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_Download");
    }
    /**
     * @return <i>Useful Links</i>
     * @see HelpWidget
     */
    static String LBL_OnlineLinks() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_OnlineLinks");
    }
    /**
     * @return <i>Show Dash on Startup</i>
     * @see IDEInfoWidget
     */
    static String LBL_ShowOnStartup() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_ShowOnStartup");
    }
    /**
     * @return <i>Keyboard Shortcuts</i>
     * @see HelpWidget
     */
    static String LBL_ShowShortcuts() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_ShowShortcuts");
    }
    /**
     * @return <i>PraxisLIVE website</i>
     * @see HelpWidget
     */
    static String LBL_WebsiteLink() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LBL_WebsiteLink");
    }
    /**
     * @return <i>https://www.praxislive.org/documentation/</i>
     * @see package-info
     */
    static String LINK_Documentation() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LINK_Documentation");
    }
    /**
     * @return <i>https://www.praxislive.org/download/</i>
     * @see package-info
     */
    static String LINK_Download() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LINK_Download");
    }
    /**
     * @return <i>https://www.praxislive.org/issues/</i>
     * @see package-info
     */
    static String LINK_Issues() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LINK_Issues");
    }
    /**
     * @return <i>https://www.praxislive.org/community/</i>
     * @see package-info
     */
    static String LINK_Support() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LINK_Support");
    }
    /**
     * @return <i>https://www.praxislive.org</i>
     * @see package-info
     */
    static String LINK_Website() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "LINK_Website");
    }
    /**
     * @return <i>Show dash on startup of the IDE.</i>
     * @see IDEInfoWidget
     */
    static String STATUS_ShowOnStartup() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "STATUS_ShowOnStartup");
    }
    /**
     * @return <i>Show and edit keyboard shortcuts.</i>
     * @see HelpWidget
     */
    static String STATUS_ShowShortcuts() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "STATUS_ShowShortcuts");
    }
    /**
     * @return <i>PraxisLIVE</i>
     * @see package-info
     */
    static String TITLE_Application() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TITLE_Application");
    }
    /**
     * @return <i>Learn &amp; Discover</i>
     * @see HelpWidget
     */
    static String TITLE_Help() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TITLE_Help");
    }
    /**
     * @return <i>Projects</i>
     * @see ProjectWidget
     */
    static String TITLE_Projects() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TITLE_Projects");
    }
    /**
     * @param current_version current version
     * @return <i>Version : </i>{@code current_version}
     * @see IDEInfoWidget
     */
    static String TXT_CurrentVersion(Object current_version) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TXT_CurrentVersion", current_version);
    }
    /**
     * @param latest_version latest version
     * @return <i>Latest : </i>{@code latest_version}
     * @see IDEInfoWidget
     */
    static String TXT_LatestVersion(Object latest_version) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TXT_LatestVersion", latest_version);
    }
    private Bundle() {}
}
