/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.ui;

import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import org.netbeans.spi.dashboard.DashboardDisplayer;
import org.netbeans.spi.dashboard.DashboardWidget;
import org.netbeans.spi.dashboard.WidgetElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.praxislive.ide.core.api.IDE;
import org.praxislive.ide.core.ui.Bundle;

public class IDEInfoWidget
implements DashboardWidget {
    private final List<WidgetElement> elements;
    private final Action showOnStartupAction;

    public IDEInfoWidget() {
        FileObject configFolder = FileUtil.getConfigFile((String)"Dashboard/Main");
        this.showOnStartupAction = new ShowOnStartupAction(configFolder);
        String currentVersion = IDE.getVersion();
        String latestVersion = IDE.getLatestAvailableVersion();
        boolean hasUpdate = !Objects.equals(currentVersion, latestVersion);
        ArrayList<Object> elems = new ArrayList<Object>();
        elems.add(WidgetElement.image((String)"org/praxislive/ide/core/ui/resources/logo128.png"));
        elems.add(WidgetElement.text((String)(Bundle.TXT_CurrentVersion(currentVersion) + "\n" + Bundle.TXT_LatestVersion(latestVersion))));
        if (hasUpdate) {
            elems.add(WidgetElement.linkButton((String)Bundle.LBL_Download(), (URI)URI.create(Bundle.LINK_Download())));
        }
        elems.add(WidgetElement.component(() -> new JCheckBox(this.showOnStartupAction)));
        this.elements = List.copyOf(elems);
    }

    public String title(DashboardDisplayer.Panel pnl) {
        return "";
    }

    public List<WidgetElement> elements(DashboardDisplayer.Panel pnl) {
        return this.elements;
    }

    private static class ShowOnStartupAction
    extends AbstractAction {
        private final FileObject configFile;

        private ShowOnStartupAction(FileObject configFile) {
            super(Bundle.LBL_ShowOnStartup());
            this.configFile = configFile;
            this.putValue("ShortDescription", Bundle.STATUS_ShowOnStartup());
            if (configFile != null) {
                this.putValue("SwingSelectedKey", Boolean.TRUE.equals(configFile.getAttribute("showOnStartup")));
            } else {
                this.putValue("SwingSelectedKey", false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.configFile != null) {
                try {
                    this.configFile.setAttribute("showOnStartup", (Object)Boolean.TRUE.equals(this.getValue("SwingSelectedKey")));
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }
}

