/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.ui;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.prefs.Preferences;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.praxislive.ide.core.Core;
import org.praxislive.ide.core.ui.Bundle;

class Utils {
    static final URI WEBSITE_LINK = URI.create(Bundle.LINK_Website());
    static final URI DOWNLOAD_LINK = WEBSITE_LINK.resolve(Bundle.LINK_Download());
    static final URI DOCUMENTATION_LINK = WEBSITE_LINK.resolve(Bundle.LINK_Documentation());
    static final URI ISSUES_LINK = WEBSITE_LINK.resolve(Bundle.LINK_Issues());
    private static final Preferences CORE_PREFS = Core.getInstance().getInternalPreferences();

    private Utils() {
    }

    static void openExternalLink(URL link) {
        try {
            Utils.openExternalLink(link.toURI());
        }
        catch (URISyntaxException ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Unable to open link " + String.valueOf(link)), 0));
        }
    }

    static void openExternalLink(URI link) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(link);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Unable to open link " + String.valueOf(link)), 0));
    }

    static boolean isCheckForUpdates() {
        return CORE_PREFS.getBoolean("check-for-updates", true);
    }

    static void setCheckForUpdates(boolean check) {
        CORE_PREFS.putBoolean("check-for-updates", check);
    }
}

