/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.ui.api;

import java.awt.Color;
import javax.swing.UIManager;
import org.praxislive.ide.core.ui.api.UIUtils;

public enum TypeColor {
    Red("TypeColor.Red", 350.0f),
    Orange("TypeColor.Orange", 30.0f),
    Yellow("TypeColor.Yellow", 50.0f),
    Green("TypeColor.Green", 90.0f),
    Cyan("TypeColor.Cyan", 170.0f),
    Blue("TypeColor.Blue", 195.0f),
    Purple("TypeColor.Purple", 285.0f),
    Magenta("TypeColor.Magenta", 315.0f);

    private final Color selection;
    private final Color shade;
    private final Color text;

    private TypeColor(String key, float defaultHue) {
        Color uiShade = UIManager.getColor(key);
        Color uiSelection = UIManager.getColor(key + ".selected");
        Color uiText = UIManager.getColor(key + ".text");
        boolean isDark = UIUtils.isDarkTheme();
        if (uiShade != null && uiSelection != null) {
            this.shade = uiShade;
            this.selection = uiSelection;
            this.text = uiText != null ? uiText : (isDark ? uiShade : uiSelection);
        } else {
            this.shade = TypeColor.hsb(defaultHue, 50.0f, 90.0f);
            this.selection = TypeColor.hsb(defaultHue, 95.0f, 85.0f);
            this.text = isDark ? this.shade : this.selection;
        }
    }

    public Color shade() {
        return this.shade;
    }

    public Color selection() {
        return this.selection;
    }

    public Color text() {
        return this.text;
    }

    private static Color hsb(float hue, float saturation, float brightness) {
        return new Color(Color.HSBtoRGB(hue / 360.0f, saturation / 100.0f, brightness / 100.0f));
    }
}

