/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.api;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.praxislive.ide.core.api.Task;

public abstract class AbstractTask
implements Task {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Task.State state = Task.State.NEW;

    protected AbstractTask() {
    }

    @Override
    public final Task.State execute() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("execute() must be called on event thread");
        }
        if (this.state != Task.State.NEW) {
            throw new IllegalStateException("task has already been executed or cancelled");
        }
        this.updateState(Task.State.RUNNING);
        try {
            this.handleExecute();
        }
        catch (Exception ex) {
            this.updateState(Task.State.ERROR);
        }
        return this.state;
    }

    @Override
    public final Task.State getState() {
        return this.state;
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public final boolean cancel() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("cancel() must be called on event thread");
        }
        if ((this.state == Task.State.NEW || this.state == Task.State.RUNNING) && this.handleCancel()) {
            this.updateState(Task.State.CANCELLED);
            return true;
        }
        return false;
    }

    protected final void updateState(Task.State newState) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("updateState() must be called on event thread");
        }
        if (this.state == newState) {
            return;
        }
        switch (newState) {
            case RUNNING: {
                if (this.state == Task.State.NEW) break;
                throw new IllegalStateException("Trying to set finished task back to running");
            }
            case COMPLETED: 
            case ERROR: 
            case CANCELLED: {
                if (this.state == Task.State.NEW || this.state == Task.State.RUNNING) break;
                throw new IllegalStateException("Trying to set state of finished task");
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Task.State old = this.state;
        this.state = newState;
        this.pcs.firePropertyChange("state", (Object)old, (Object)this.state);
    }

    protected abstract void handleExecute() throws Exception;

    protected boolean handleCancel() {
        return false;
    }

    public static abstract class WithResult<T>
    extends AbstractTask
    implements Task.WithResult<T> {
        private T result;

        @Override
        public final T result() {
            if (!EventQueue.isDispatchThread()) {
                throw new IllegalStateException("Not on event dispatch thread");
            }
            if (this.getState() != Task.State.COMPLETED) {
                throw new IllegalStateException("Task is not successfully completed");
            }
            return this.result;
        }

        protected final void complete(T result) {
            if (!EventQueue.isDispatchThread()) {
                throw new IllegalStateException("Not on event dispatch thread");
            }
            if (this.getState() != Task.State.RUNNING) {
                throw new IllegalStateException("Task state is not running");
            }
            this.result = result;
            this.updateState(Task.State.COMPLETED);
        }
    }
}

