/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.api;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.praxislive.core.Value;
import org.praxislive.core.types.PError;
import org.praxislive.ide.core.api.CallExecutionException;

public interface Callback {
    public void onReturn(List<Value> var1);

    public void onError(List<Value> var1);

    public static Callback create(Consumer<Result> callback) {
        return new Result.ResultCallback(callback);
    }

    public static Callback create(final CompletableFuture<List<Value>> future) {
        return new Callback(){

            @Override
            public void onError(List<Value> args) {
                CallExecutionException ex = args.stream().flatMap(v -> PError.from((Value)v).stream()).map(CallExecutionException::new).findFirst().orElseGet(() -> new CallExecutionException(args.isEmpty() ? PError.of((String)"Unknown call error") : PError.of((String)((Value)args.get(0)).toString())));
                future.completeExceptionally(ex);
            }

            @Override
            public void onReturn(List<Value> args) {
                future.complete(args);
            }
        };
    }

    public static final class Result {
        private final boolean error;
        private final List<Value> args;

        private Result(boolean error, List<Value> args) {
            this.error = error;
            this.args = args;
        }

        public boolean isError() {
            return this.error;
        }

        public List<Value> args() {
            return this.args;
        }

        private static class ResultCallback
        implements Callback {
            private final Consumer<Result> callback;

            private ResultCallback(Consumer<Result> callback) {
                this.callback = Objects.requireNonNull(callback);
            }

            @Override
            public void onReturn(List<Value> args) {
                this.callback.accept(new Result(false, List.copyOf(args)));
            }

            @Override
            public void onError(List<Value> args) {
                this.callback.accept(new Result(true, List.copyOf(args)));
            }
        }
    }
}

