/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.api;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openide.util.Lookup;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.Info;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Value;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.services.LogService;
import org.praxislive.ide.core.api.AbstractIDERoot;
import org.praxislive.ide.core.spi.LogHandler;

@Deprecated
public final class Logging
extends AbstractIDERoot {
    private static final ComponentInfo INFO = Info.component().control("log", LogService.LOG_INFO).protocol(LogService.class).build();
    private final List<LogHandler> handlers;

    private Logging(List<LogHandler> handlers) {
        this.handlers = handlers.isEmpty() ? List.of(new FallbackHandler()) : handlers;
        this.registerControl("log", new LogControl());
    }

    public ComponentInfo getInfo() {
        return INFO;
    }

    public LogLevel getLogLevel() {
        LogLevel level = LogLevel.ERROR;
        for (LogHandler handler : this.handlers) {
            LogLevel l = handler.getLevel();
            if (level.isLoggable(l)) continue;
            level = l;
        }
        return level;
    }

    protected void stopping() {
        this.handlers.forEach(LogHandler::close);
    }

    private void dispatch(ComponentAddress src, long time, LogLevel level, Value arg) {
        this.handlers.forEach(handler -> handler.log(src, time, level, arg));
    }

    public static Logging create(Lookup context) {
        List handlers = Lookup.getDefault().lookupAll(LogHandler.Provider.class).stream().flatMap(p -> p.createLogHandler(context).stream()).collect(Collectors.toList());
        return new Logging(List.copyOf(handlers));
    }

    private static class FallbackHandler
    implements LogHandler {
        private FallbackHandler() {
        }

        @Override
        public void log(ComponentAddress source, long time, LogLevel level, Value message) {
            Level jlevel = Level.SEVERE;
            switch (level) {
                case WARNING: {
                    jlevel = Level.WARNING;
                    break;
                }
                case INFO: {
                    jlevel = Level.INFO;
                    break;
                }
                case DEBUG: {
                    jlevel = Level.CONFIG;
                }
            }
            Logger.getAnonymousLogger().log(jlevel, "{0} : {1} : {2}", new Object[]{level, source, message});
        }
    }

    private class LogControl
    implements Control {
        private LogControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isRequest()) {
                ComponentAddress src = call.from().component();
                long time = call.time();
                List args = call.args();
                for (int i = 1; i < args.size(); i += 2) {
                    LogLevel level = LogLevel.valueOf((String)((Value)args.get(i - 1)).toString());
                    Logging.this.dispatch(src, time, level, (Value)args.get(i));
                }
            }
            if (call.isReplyRequired()) {
                router.route((Packet)call.reply());
            }
        }
    }
}

