/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.api;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.openide.util.Cancellable;

public interface Task
extends Cancellable {
    public static final String PROP_STATE = "state";

    public State execute();

    public State getState();

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    default public Optional<String> description() {
        return Optional.empty();
    }

    default public List<String> log() {
        return List.of();
    }

    public static CompletionStage<Void> run(Task task) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("run() must be called on event dispatch thread");
        }
        try {
            State state = task.execute();
            return switch (state.ordinal()) {
                case 2 -> throw new CancellationException();
                case 3 -> CompletableFuture.completedStage(null);
                case 1 -> {
                    CompletableFuture future = new CompletableFuture();
                    task.addPropertyChangeListener(ev -> {
                        switch (task.getState().ordinal()) {
                            case 3: {
                                future.complete(null);
                                break;
                            }
                            case 2: {
                                future.completeExceptionally(new CancellationException());
                                break;
                            }
                            case 4: {
                                future.completeExceptionally(new Exception());
                            }
                        }
                    });
                    yield future.minimalCompletionStage();
                }
                default -> throw new Exception();
            };
        }
        catch (Exception ex) {
            return CompletableFuture.failedStage(ex);
        }
    }

    public static enum State {
        NEW,
        RUNNING,
        CANCELLED,
        COMPLETED,
        ERROR;

    }

    public static interface WithResult<T>
    extends Task {
        public T result();

        public static <T> CompletionStage<T> compute(WithResult<T> task) {
            return Task.run(task).thenApply(v -> task.result());
        }
    }
}

