/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.praxislive.ide.core.Bundle;

public class Core {
    public static final String KEY_LATEST_VERSION = "latest-version";
    private static final Core INSTANCE = new Core();
    private static final RequestProcessor RP = new RequestProcessor(Core.class);
    private static final Preferences GLOBALS = NbPreferences.root().node("/org/praxislive");
    private static final Preferences INTERNAL = NbPreferences.forModule(Core.class);
    private String version;

    public String getVersion() {
        return this.version;
    }

    public String getLatestAvailableVersion() {
        return GLOBALS.get(KEY_LATEST_VERSION, this.version);
    }

    public Preferences getPreferences() {
        return GLOBALS;
    }

    public Preferences getInternalPreferences() {
        return INTERNAL;
    }

    void setVersion(String version) {
        this.version = version;
    }

    void checkForUpdates() {
        if (INTERNAL.getBoolean("check-for-updates", true) && !Boolean.getBoolean("praxislive.start.suppresscheck")) {
            RP.post((Runnable)new UpdateCheck());
        }
    }

    public static Core getInstance() {
        return INSTANCE;
    }

    private static class UpdateCheck
    implements Runnable {
        private UpdateCheck() {
        }

        @Override
        public void run() {
            Properties releaseProperties = new Properties();
            try (InputStreamReader reader = new InputStreamReader(new URL(System.getProperty("praxislive.start.infoURL", Bundle.LINK_ReleaseProperties())).openStream());){
                releaseProperties.load(reader);
                for (String key : releaseProperties.stringPropertyNames()) {
                    String value = releaseProperties.getProperty(key);
                    if (value == null || value.isEmpty()) {
                        GLOBALS.remove(key);
                        continue;
                    }
                    GLOBALS.put(key, value);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

